/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.mapping;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.dsbulk.mapping.CQLFragment;
import com.datastax.oss.dsbulk.mapping.CQLRenderMode;
import com.datastax.oss.dsbulk.mapping.CQLWord;
import com.datastax.oss.dsbulk.mapping.MappingField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class FunctionCall
implements MappingField,
CQLFragment {
    private static final Collector<CharSequence, ?, String> COMMA = Collectors.joining(", ");
    private final CQLWord keyspaceName;
    private final CQLWord functionName;
    private final ImmutableList<CQLFragment> args;
    private final String namedAssignment;
    private final String positionalAssignment;
    private final String internal;
    private final String identifier;
    private final String unaliasedSelector;
    private final String aliasedSelector;

    public FunctionCall(@Nullable CQLWord keyspaceName, @NonNull CQLWord functionName, CQLFragment ... args) {
        this(keyspaceName, functionName, Arrays.asList(args));
    }

    public FunctionCall(@Nullable CQLWord keyspaceName, @NonNull CQLWord functionName, @NonNull List<CQLFragment> args) {
        this.keyspaceName = keyspaceName;
        this.functionName = functionName;
        this.args = ImmutableList.copyOf(args);
        this.namedAssignment = this.renderNamedAssignment();
        this.positionalAssignment = this.renderPositionalAssignment();
        this.internal = this.renderInternal();
        this.identifier = CQLWord.fromInternal(this.internal).render(CQLRenderMode.VARIABLE);
        this.unaliasedSelector = this.renderUnaliasedSelector();
        this.aliasedSelector = this.renderAliasedSelector();
    }

    private String renderNamedAssignment() {
        String name = this.functionName.render(CQLRenderMode.VARIABLE);
        String argsList = this.args.stream().map(arg -> arg.render(CQLRenderMode.NAMED_ASSIGNMENT)).collect(COMMA);
        if (this.keyspaceName == null) {
            return String.format("%s(%s)", name, argsList);
        }
        return String.format("%s.%s(%s)", this.keyspaceName.render(CQLRenderMode.VARIABLE), name, argsList);
    }

    private String renderPositionalAssignment() {
        String name = this.functionName.render(CQLRenderMode.VARIABLE);
        String argsList = this.args.stream().map(arg -> arg.render(CQLRenderMode.POSITIONAL_ASSIGNMENT)).collect(COMMA);
        if (this.keyspaceName == null) {
            return String.format("%s(%s)", name, argsList);
        }
        return String.format("%s.%s(%s)", this.keyspaceName.render(CQLRenderMode.VARIABLE), name, argsList);
    }

    private String renderInternal() {
        String name = this.functionName.render(CQLRenderMode.INTERNAL);
        String argsList = this.args.stream().map(arg -> arg.render(CQLRenderMode.INTERNAL)).collect(COMMA);
        if (this.keyspaceName == null) {
            return String.format("%s(%s)", name, argsList);
        }
        return String.format("%s.%s(%s)", this.keyspaceName.render(CQLRenderMode.INTERNAL), name, argsList);
    }

    private String renderUnaliasedSelector() {
        String name = this.functionName.render(CQLRenderMode.VARIABLE);
        String argsList = this.args.stream().map(arg -> arg.render(CQLRenderMode.UNALIASED_SELECTOR)).collect(COMMA);
        if (this.keyspaceName == null) {
            return String.format("%s(%s)", name, argsList);
        }
        return String.format("%s.%s(%s)", this.keyspaceName.render(CQLRenderMode.VARIABLE), name, argsList);
    }

    private String renderAliasedSelector() {
        return String.format("%s AS %s", this.unaliasedSelector, this.identifier);
    }

    @NonNull
    public Optional<CQLWord> getKeyspaceName() {
        return Optional.ofNullable(this.keyspaceName);
    }

    @NonNull
    public CQLWord getFunctionName() {
        return this.functionName;
    }

    @NonNull
    public String getFieldDescription() {
        return this.render(CQLRenderMode.INTERNAL);
    }

    @NonNull
    public ImmutableList<CQLFragment> getArgs() {
        return this.args;
    }

    @Override
    public String render(CQLRenderMode mode) {
        switch (mode) {
            case NAMED_ASSIGNMENT: {
                return this.namedAssignment;
            }
            case POSITIONAL_ASSIGNMENT: {
                return this.positionalAssignment;
            }
            case UNALIASED_SELECTOR: {
                return this.unaliasedSelector;
            }
            case ALIASED_SELECTOR: {
                return this.aliasedSelector;
            }
            case VARIABLE: {
                return this.identifier;
            }
        }
        return this.internal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionCall)) {
            return false;
        }
        FunctionCall that = (FunctionCall)o;
        return Objects.equals(this.keyspaceName, that.keyspaceName) && this.functionName.equals(that.functionName) && this.args.equals(that.args);
    }

    public int hashCode() {
        return Objects.hash(this.keyspaceName, this.functionName, this.args);
    }

    public String toString() {
        return this.getFieldDescription();
    }
}

