/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.mapping;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSetMultimap;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecFactory;
import com.datastax.oss.dsbulk.codecs.api.writetime.WriteTimeCodec;
import com.datastax.oss.dsbulk.connectors.api.Field;
import com.datastax.oss.dsbulk.mapping.CQLWord;
import com.datastax.oss.dsbulk.mapping.Mapping;
import com.datastax.oss.dsbulk.mapping.MappingToken;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;

public class DefaultMapping
implements Mapping {
    private final ImmutableSetMultimap<Field, CQLWord> fieldsToVariables;
    private final ImmutableSetMultimap<CQLWord, Field> variablesToFields;
    private final ConvertingCodecFactory codecFactory;
    private final Cache<MappingToken, TypeCodec<?>> variablesToCodecs;
    private final ImmutableSet<CQLWord> writeTimeVariables;

    public DefaultMapping(ImmutableSetMultimap<Field, CQLWord> fieldsToVariables, ConvertingCodecFactory codecFactory, ImmutableSet<CQLWord> writeTimeVariables) {
        this.fieldsToVariables = fieldsToVariables;
        this.codecFactory = codecFactory;
        this.writeTimeVariables = writeTimeVariables;
        this.variablesToCodecs = Caffeine.newBuilder().build();
        this.variablesToFields = fieldsToVariables.inverse();
    }

    @Override
    @NonNull
    public Set<CQLWord> fieldToVariables(@NonNull Field field) {
        return this.fieldsToVariables.get((Object)field);
    }

    @Override
    @NonNull
    public Set<Field> variableToFields(@NonNull CQLWord variable) {
        return this.variablesToFields.get((Object)variable);
    }

    @Override
    @NonNull
    public Set<Field> fields() {
        return this.fieldsToVariables.keySet();
    }

    @Override
    @NonNull
    public Set<CQLWord> variables() {
        return this.variablesToFields.keySet();
    }

    @Override
    @NonNull
    public <T> TypeCodec<T> codec(@NonNull CQLWord variable, @NonNull DataType cqlType, @NonNull GenericType<? extends T> javaType) {
        TypeCodec codec = (TypeCodec)this.variablesToCodecs.get((Object)variable, n -> {
            if (this.writeTimeVariables.contains((Object)variable)) {
                return this.createWritetimeCodec(cqlType, javaType);
            }
            return this.codecFactory.createConvertingCodec(cqlType, javaType, true);
        });
        assert (codec != null);
        return codec;
    }

    @NonNull
    private <T> WriteTimeCodec<T> createWritetimeCodec(@NonNull DataType cqlType, @NonNull GenericType<T> javaType) {
        if (!cqlType.equals(DataTypes.BIGINT)) {
            throw new IllegalArgumentException("Cannot create a WriteTimeCodec for " + cqlType);
        }
        ConvertingCodec innerCodec = this.codecFactory.createConvertingCodec(DataTypes.TIMESTAMP, javaType, true);
        return new WriteTimeCodec(innerCodec);
    }
}

