/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.mapping;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.dsbulk.mapping.CQLFragment;
import com.datastax.oss.dsbulk.mapping.CQLRenderMode;
import edu.umd.cs.findbugs.annotations.NonNull;

public class CQLWord
implements CQLFragment {
    private final CqlIdentifier identifier;

    @NonNull
    public static CQLWord fromCql(@NonNull String cql) {
        return CQLWord.fromCqlIdentifier(CqlIdentifier.fromCql((String)cql));
    }

    @NonNull
    public static CQLWord fromInternal(@NonNull String internal) {
        return CQLWord.fromCqlIdentifier(CqlIdentifier.fromInternal((String)internal));
    }

    @NonNull
    public static CQLWord fromCqlIdentifier(@NonNull CqlIdentifier identifier) {
        return new CQLWord(identifier);
    }

    private CQLWord(@NonNull CqlIdentifier identifier) {
        this.identifier = identifier;
    }

    public CqlIdentifier asIdentifier() {
        return this.identifier;
    }

    @Override
    public String render(CQLRenderMode mode) {
        switch (mode) {
            case NAMED_ASSIGNMENT: {
                return ':' + this.identifier.asCql(true);
            }
            case POSITIONAL_ASSIGNMENT: {
                return "?";
            }
            case ALIASED_SELECTOR: 
            case UNALIASED_SELECTOR: 
            case VARIABLE: {
                return this.identifier.asCql(true);
            }
        }
        return this.identifier.asInternal();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof CQLWord) {
            CQLWord that = (CQLWord)other;
            return this.identifier.equals((Object)that.identifier);
        }
        return false;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public String toString() {
        return this.identifier.asInternal();
    }
}

