/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.format.statement;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.dsbulk.format.statement.StatementFormatterLimits;
import com.datastax.oss.dsbulk.format.statement.StatementFormatterSymbols;
import com.datastax.oss.dsbulk.format.statement.StatementPrinterRegistry;
import java.nio.ByteBuffer;

public final class StatementWriter
implements Appendable {
    private static final int MAX_EXCEEDED = -2;
    private final StringBuilder buffer;
    private final int indentation;
    private final StatementPrinterRegistry printerRegistry;
    private final StatementFormatterLimits limits;
    private final ProtocolVersion protocolVersion;
    private final CodecRegistry codecRegistry;
    private int remainingQueryStringChars;
    private int remainingBoundValues;

    StatementWriter(StringBuilder buffer, int indentation, StatementPrinterRegistry printerRegistry, StatementFormatterLimits limits, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        this.buffer = buffer;
        this.indentation = indentation;
        this.printerRegistry = printerRegistry;
        this.limits = limits;
        this.protocolVersion = protocolVersion;
        this.codecRegistry = codecRegistry;
        this.remainingQueryStringChars = limits.maxQueryStringLength == -1 ? Integer.MAX_VALUE : limits.maxQueryStringLength;
        this.remainingBoundValues = limits.maxBoundValues == -1 ? Integer.MAX_VALUE : limits.maxBoundValues;
    }

    public StatementWriter createChildWriter() {
        return new StatementWriter(this.buffer, this.indentation + 4, this.printerRegistry, this.limits, this.protocolVersion, this.codecRegistry);
    }

    public StatementPrinterRegistry getPrinterRegistry() {
        return this.printerRegistry;
    }

    public StatementFormatterLimits getLimits() {
        return this.limits;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public boolean maxQueryStringLengthExceeded() {
        return this.remainingQueryStringChars == -2;
    }

    public boolean maxAppendedBoundValuesExceeded() {
        return this.remainingBoundValues == -2;
    }

    public StatementWriter newLine() {
        this.buffer.append(StatementFormatterSymbols.lineSeparator);
        return this;
    }

    public StatementWriter indent() {
        for (int i = 0; i < this.indentation; ++i) {
            this.buffer.append(' ');
        }
        return this;
    }

    @Override
    public StatementWriter append(CharSequence csq) {
        this.buffer.append(csq);
        return this;
    }

    @Override
    public StatementWriter append(CharSequence csq, int start, int end) {
        this.buffer.append(csq, start, end);
        return this;
    }

    @Override
    public StatementWriter append(char c) {
        this.buffer.append(c);
        return this;
    }

    public StatementWriter append(Object obj) {
        this.buffer.append(obj);
        return this;
    }

    public StatementWriter append(String str) {
        this.buffer.append(str);
        return this;
    }

    public StatementWriter appendClassNameAndHashCode(Statement<?> statement) {
        String fqcn = statement.getClass().getName();
        if (fqcn.startsWith("com.datastax.driver.core.querybuilder")) {
            fqcn = "BuiltStatement";
        }
        if (fqcn.startsWith("com.datastax.driver.core.schemabuilder")) {
            fqcn = "SchemaStatement";
        } else if (fqcn.startsWith("com.datastax.driver.core.")) {
            fqcn = fqcn.substring(25);
        } else if (fqcn.startsWith("com.datastax.oss.dsbulk.executor.api.statement.")) {
            fqcn = fqcn.substring(43);
        }
        this.buffer.append(fqcn);
        this.buffer.append('@');
        this.buffer.append(Integer.toHexString(statement.hashCode()));
        return this;
    }

    public void appendQueryStringFragment(String queryStringFragment) {
        if (!this.maxQueryStringLengthExceeded() && !queryStringFragment.isEmpty()) {
            if (this.limits.maxQueryStringLength == -1) {
                this.buffer.append(queryStringFragment);
            } else if (queryStringFragment.length() > this.remainingQueryStringChars) {
                if (this.remainingQueryStringChars > 0) {
                    queryStringFragment = queryStringFragment.substring(0, this.remainingQueryStringChars);
                    this.buffer.append(queryStringFragment);
                }
                this.buffer.append("...");
                this.remainingQueryStringChars = -2;
            } else {
                this.buffer.append(queryStringFragment);
                this.remainingQueryStringChars -= queryStringFragment.length();
            }
        }
    }

    public void appendBoundValue(int index, Object value, DataType type) {
        if (this.maxAppendedBoundValuesExceeded()) {
            return;
        }
        this.appendBoundValue(Integer.toString(index), value, type);
    }

    public void appendBoundValue(String name, Object value, DataType type) {
        if (this.maxAppendedBoundValuesExceeded()) {
            return;
        }
        if (value == null) {
            this.doAppendBoundValue(name, "<NULL>");
            return;
        }
        if (value instanceof ByteBuffer && this.limits.maxBoundValueLength != -1) {
            boolean bufferLengthExceeded;
            ByteBuffer byteBuffer = (ByteBuffer)value;
            int maxBufferLengthInBytes = Math.max(2, this.limits.maxBoundValueLength / 2) - 1;
            boolean bl = bufferLengthExceeded = byteBuffer.remaining() > maxBufferLengthInBytes;
            if (bufferLengthExceeded) {
                byteBuffer = byteBuffer.duplicate();
                byteBuffer.limit(maxBufferLengthInBytes);
                String formatted = TypeCodecs.BLOB.format((Object)byteBuffer);
                this.doAppendBoundValue(name, formatted);
                this.buffer.append("...");
                return;
            }
        }
        TypeCodec codec = type == null ? this.codecRegistry.codecFor(value) : this.codecRegistry.codecFor(type, value);
        this.doAppendBoundValue(name, codec.format(value));
    }

    public void appendUnsetBoundValue(String name) {
        this.doAppendBoundValue(name, "<UNSET>");
    }

    private void doAppendBoundValue(String name, String value) {
        if (this.maxAppendedBoundValuesExceeded()) {
            return;
        }
        if (this.remainingBoundValues == 0) {
            this.buffer.append("...");
            this.remainingBoundValues = -2;
            return;
        }
        boolean lengthExceeded = false;
        if (this.limits.maxBoundValueLength != -1 && value.length() > this.limits.maxBoundValueLength) {
            value = value.substring(0, this.limits.maxBoundValueLength);
            lengthExceeded = true;
        }
        if (name != null) {
            this.buffer.append(name);
            this.buffer.append(": ");
        }
        this.buffer.append(value);
        if (lengthExceeded) {
            this.buffer.append("...");
        }
        if (this.limits.maxBoundValues != -1) {
            --this.remainingBoundValues;
        }
    }

    public String toString() {
        return this.buffer.toString();
    }
}

