/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.format.statement;

import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.dsbulk.format.statement.BatchStatementPrinter;
import com.datastax.oss.dsbulk.format.statement.BoundStatementPrinter;
import com.datastax.oss.dsbulk.format.statement.DefaultStatementPrinter;
import com.datastax.oss.dsbulk.format.statement.SimpleStatementPrinter;
import com.datastax.oss.dsbulk.format.statement.StatementPrinter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class StatementPrinterRegistry {
    private static final ImmutableMap<Class<?>, StatementPrinter<?>> BUILT_IN_PRINTERS = ImmutableMap.builder().put(SimpleStatement.class, (Object)new SimpleStatementPrinter()).put(BoundStatement.class, (Object)new BoundStatementPrinter()).put(BatchStatement.class, (Object)new BatchStatementPrinter()).put(Statement.class, (Object)new DefaultStatementPrinter()).build();
    private final ConcurrentMap<Class<?>, StatementPrinter<?>> printers = new ConcurrentHashMap();

    StatementPrinterRegistry() {
    }

    public <S extends Statement<S>> StatementPrinter<S> findPrinter(Class<? extends S> statementClass) {
        Class<?> ifc;
        int n;
        int n2;
        Class<?>[] classArray;
        StatementPrinter<?> printer = StatementPrinterRegistry.lookupPrinter(statementClass, this.printers);
        if (printer == null) {
            classArray = statementClass.getInterfaces();
            n2 = classArray.length;
            for (n = 0; n < n2 && (printer = StatementPrinterRegistry.lookupPrinter(ifc = classArray[n], this.printers)) == null; ++n) {
            }
        }
        if (printer == null) {
            printer = StatementPrinterRegistry.lookupPrinter(statementClass, BUILT_IN_PRINTERS);
        }
        if (printer == null) {
            classArray = statementClass.getInterfaces();
            n2 = classArray.length;
            for (n = 0; n < n2 && (printer = StatementPrinterRegistry.lookupPrinter(ifc = classArray[n], BUILT_IN_PRINTERS)) == null; ++n) {
            }
        }
        assert (printer != null);
        StatementPrinter<?> sp = printer;
        return sp;
    }

    public <S extends Statement<S>> void register(StatementPrinter<S> printer) {
        this.printers.put(printer.getSupportedStatementClass(), printer);
    }

    private static StatementPrinter<?> lookupPrinter(Class<?> clazz, Map<Class<?>, StatementPrinter<?>> map) {
        StatementPrinter<?> printer;
        block3: {
            block2: {
                Class<?> ifc;
                printer = null;
                if (!clazz.isInterface()) break block2;
                printer = map.get(clazz);
                if (printer != null) break block3;
                Class<?>[] classArray = clazz.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (printer = StatementPrinterRegistry.lookupPrinter(ifc = classArray[i], map)) == null; ++i) {
                }
                break block3;
            }
            for (Class<?> key = clazz; printer == null && key != null; key = key.getSuperclass()) {
                printer = map.get(key);
            }
        }
        return printer;
    }
}

