/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.format.statement;

import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.dsbulk.format.statement.StatementFormatVerbosity;
import com.datastax.oss.dsbulk.format.statement.StatementPrinter;
import com.datastax.oss.dsbulk.format.statement.StatementWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class StatementPrinterBase<S extends Statement<S>>
implements StatementPrinter<S> {
    @Override
    public abstract Class<? extends S> getSupportedStatementClass();

    @Override
    public void print(S statement, StatementWriter out, StatementFormatVerbosity verbosity) {
        this.printHeader(statement, out, verbosity);
        if (verbosity.compareTo(StatementFormatVerbosity.NORMAL) >= 0) {
            this.printQueryString(statement, out, verbosity);
            if (verbosity.compareTo(StatementFormatVerbosity.EXTENDED) >= 0) {
                this.printBoundValues(statement, out, verbosity);
            }
        }
    }

    protected void printHeader(S statement, StatementWriter out, StatementFormatVerbosity verbosity) {
        out.appendClassNameAndHashCode((Statement<?>)statement);
        List<String> properties = this.collectStatementProperties(statement, out, verbosity);
        if (properties != null && !properties.isEmpty()) {
            out.append(" [");
            Iterator<String> it = properties.iterator();
            while (it.hasNext()) {
                String property = it.next();
                out.append(property);
                if (!it.hasNext()) continue;
                out.append(", ");
            }
            out.append("]");
        }
    }

    protected List<String> collectStatementProperties(S statement, StatementWriter out, StatementFormatVerbosity verbosity) {
        ArrayList<String> properties = new ArrayList<String>();
        if (verbosity.compareTo(StatementFormatVerbosity.NORMAL) > 0) {
            if (statement.isIdempotent() != null) {
                properties.add(String.format("idempotence: %s", statement.isIdempotent()));
            } else {
                properties.add(String.format("idempotence: %s", "<UNSET>"));
            }
            if (statement.getConsistencyLevel() != null) {
                properties.add(String.format("CL: %s", statement.getConsistencyLevel()));
            } else {
                properties.add(String.format("CL: %s", "<UNSET>"));
            }
            if (statement.getSerialConsistencyLevel() != null) {
                properties.add(String.format("serial CL: %s", statement.getSerialConsistencyLevel()));
            } else {
                properties.add(String.format("serial CL: %s", "<UNSET>"));
            }
            if (statement.getQueryTimestamp() != Long.MIN_VALUE) {
                properties.add(String.format("timestamp: %s", statement.getQueryTimestamp()));
            } else {
                properties.add(String.format("timestamp: %s", "<UNSET>"));
            }
            if (statement.getTimeout() != null) {
                properties.add(String.format("timeout: %s", statement.getTimeout()));
            } else {
                properties.add(String.format("timeout: %s", "<UNSET>"));
            }
        }
        return properties;
    }

    protected void printQueryString(S statement, StatementWriter out, StatementFormatVerbosity verbosity) {
    }

    protected void printBoundValues(S statement, StatementWriter out, StatementFormatVerbosity verbosity) {
    }
}

