/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.format.statement;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.dsbulk.format.statement.StatementFormatVerbosity;
import com.datastax.oss.dsbulk.format.statement.StatementFormatterLimits;
import com.datastax.oss.dsbulk.format.statement.StatementPrinter;
import com.datastax.oss.dsbulk.format.statement.StatementPrinterRegistry;
import com.datastax.oss.dsbulk.format.statement.StatementWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatementFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatementFormatter.class);
    private final StatementPrinterRegistry printerRegistry;
    private final StatementFormatterLimits limits;

    public static Builder builder() {
        return new Builder();
    }

    private StatementFormatter(StatementPrinterRegistry printerRegistry, StatementFormatterLimits limits) {
        this.printerRegistry = printerRegistry;
        this.limits = limits;
    }

    public String format(Statement<?> statement, StatementFormatVerbosity verbosity, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        try {
            StatementPrinter<?> printer = this.printerRegistry.findPrinter(statement.getClass());
            assert (printer != null) : "Could not find printer for statement class " + statement.getClass();
            StatementWriter out = new StatementWriter(new StringBuilder(), 0, this.printerRegistry, this.limits, protocolVersion, codecRegistry);
            printer.print(statement, out, verbosity);
            return out.toString();
        }
        catch (Exception e) {
            try {
                LOGGER.error("Could not format statement: " + statement, (Throwable)e);
                return statement.toString();
            }
            catch (Exception e1) {
                LOGGER.error("statement.toString() failed", (Throwable)e1);
                return "statement[?]";
            }
        }
    }

    public static class Builder {
        static final int DEFAULT_MAX_QUERY_STRING_LENGTH = 500;
        static final int DEFAULT_MAX_BOUND_VALUE_LENGTH = 50;
        static final int DEFAULT_MAX_BOUND_VALUES = 10;
        static final int DEFAULT_MAX_INNER_STATEMENTS = 5;
        static final int DEFAULT_MAX_OUTGOING_PAYLOAD_ENTRIES = 10;
        static final int DEFAULT_MAX_OUTGOING_PAYLOAD_VALUE_LENGTH = 50;
        private int maxQueryStringLength = 500;
        private int maxBoundValueLength = 50;
        private int maxBoundValues = 10;
        private int maxInnerStatements = 5;
        private int maxOutgoingPayloadEntries = 10;
        private int maxOutgoingPayloadValueLength = 50;
        private final List<StatementPrinter<?>> printers = new ArrayList();

        private Builder() {
        }

        public Builder addStatementPrinters(StatementPrinter<?> ... printers) {
            this.printers.addAll(Arrays.asList(printers));
            return this;
        }

        public Builder withMaxQueryStringLength(int maxQueryStringLength) {
            if (maxQueryStringLength <= 0 && maxQueryStringLength != -1) {
                throw new IllegalArgumentException("Invalid maxQueryStringLength, should be > 0 or -1 (unlimited), got " + maxQueryStringLength);
            }
            this.maxQueryStringLength = maxQueryStringLength;
            return this;
        }

        public Builder withMaxBoundValueLength(int maxBoundValueLength) {
            if (maxBoundValueLength <= 0 && maxBoundValueLength != -1) {
                throw new IllegalArgumentException("Invalid maxBoundValueLength, should be > 0 or -1 (unlimited), got " + maxBoundValueLength);
            }
            this.maxBoundValueLength = maxBoundValueLength;
            return this;
        }

        public Builder withMaxBoundValues(int maxBoundValues) {
            if (maxBoundValues <= 0 && maxBoundValues != -1) {
                throw new IllegalArgumentException("Invalid maxBoundValues, should be > 0 or -1 (unlimited), got " + maxBoundValues);
            }
            this.maxBoundValues = maxBoundValues;
            return this;
        }

        public Builder withMaxInnerStatements(int maxInnerStatements) {
            if (maxInnerStatements < 0 && maxInnerStatements != -1) {
                throw new IllegalArgumentException("Invalid maxInnerStatements, should be >= 0 or -1 (unlimited), got " + maxInnerStatements);
            }
            this.maxInnerStatements = maxInnerStatements;
            return this;
        }

        public StatementFormatter build() {
            StatementPrinterRegistry registry = new StatementPrinterRegistry();
            for (StatementPrinter<?> printer : this.printers) {
                registry.register(printer);
            }
            StatementFormatterLimits limits = new StatementFormatterLimits(this.maxQueryStringLength, this.maxBoundValueLength, this.maxBoundValues, this.maxInnerStatements, this.maxOutgoingPayloadEntries, this.maxOutgoingPayloadValueLength);
            return new StatementFormatter(registry, limits);
        }
    }
}

