/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.format.statement;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.dsbulk.format.statement.StatementFormatVerbosity;
import com.datastax.oss.dsbulk.format.statement.StatementPrinterBase;
import com.datastax.oss.dsbulk.format.statement.StatementWriter;
import java.util.List;

public class BoundStatementPrinter
extends StatementPrinterBase<BoundStatement> {
    @Override
    public Class<? extends BoundStatement> getSupportedStatementClass() {
        return BoundStatement.class;
    }

    @Override
    protected List<String> collectStatementProperties(BoundStatement statement, StatementWriter out, StatementFormatVerbosity verbosity) {
        List<String> properties = super.collectStatementProperties(statement, out, verbosity);
        ColumnDefinitions metadata = statement.getPreparedStatement().getVariableDefinitions();
        properties.add(0, String.format("%s values", metadata.size()));
        return properties;
    }

    @Override
    protected void printQueryString(BoundStatement statement, StatementWriter out, StatementFormatVerbosity verbosity) {
        out.newLine().indent().appendQueryStringFragment(statement.getPreparedStatement().getQuery());
    }

    @Override
    protected void printBoundValues(BoundStatement statement, StatementWriter out, StatementFormatVerbosity verbosity) {
        if (statement.getPreparedStatement().getVariableDefinitions().size() > 0) {
            ColumnDefinitions metadata = statement.getPreparedStatement().getVariableDefinitions();
            for (int i = 0; i < metadata.size(); ++i) {
                out.newLine().indent();
                if (statement.isSet(i)) {
                    out.appendBoundValue(metadata.get(i).getName().asInternal(), statement.getObject(i), metadata.get(i).getType());
                } else {
                    out.appendUnsetBoundValue(metadata.get(i).getName().asInternal());
                }
                if (out.maxAppendedBoundValuesExceeded()) break;
            }
        }
    }
}

