/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.format.statement;

import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.dsbulk.format.statement.StatementFormatVerbosity;
import com.datastax.oss.dsbulk.format.statement.StatementPrinter;
import com.datastax.oss.dsbulk.format.statement.StatementWriter;

public class BatchStatementPrinter
implements StatementPrinter<BatchStatement> {
    @Override
    public Class<BatchStatement> getSupportedStatementClass() {
        return BatchStatement.class;
    }

    @Override
    public void print(BatchStatement statement, StatementWriter out, StatementFormatVerbosity verbosity) {
        out.appendClassNameAndHashCode((Statement<?>)statement).append(" [").append(statement.getBatchType()).append(", ").append(String.format("%s stmts", statement.size()));
        if (verbosity.compareTo(StatementFormatVerbosity.NORMAL) > 0) {
            out.append(", ").append(String.format("%s values", BatchStatementPrinter.valuesCount(statement)));
        }
        out.append("]");
        if (verbosity.compareTo(StatementFormatVerbosity.NORMAL) >= 0 && out.getLimits().maxInnerStatements > 0) {
            out.newLine();
            int i = 1;
            for (Statement stmt : statement) {
                if (i > out.getLimits().maxInnerStatements) {
                    out.append("...");
                    break;
                }
                out.append(i++).append(": ");
                StatementPrinter<?> printer = out.getPrinterRegistry().findPrinter(stmt.getClass());
                out.indent();
                printer.print(stmt, out.createChildWriter(), verbosity);
                out.newLine();
            }
        }
    }

    private static int valuesCount(BatchStatement batchStatement) {
        int count = 0;
        for (BatchableStatement statement : batchStatement) {
            if (statement instanceof BoundStatement) {
                count += ((BoundStatement)statement).size();
                continue;
            }
            if (!(statement instanceof SimpleStatement)) continue;
            count += ((SimpleStatement)statement).getNamedValues().size() + ((SimpleStatement)statement).getPositionalValues().size();
        }
        return count;
    }
}

