/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.format.row;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.dsbulk.format.row.RowFormatterSymbols;
import java.nio.ByteBuffer;

public final class RowWriter
implements Appendable {
    private static final int MAX_EXCEEDED = -1;
    private final StringBuilder buffer;
    private final int indentation;
    private final int maxValueLength;
    private final int maxValues;
    private final ProtocolVersion protocolVersion;
    private final CodecRegistry codecRegistry;
    private int remainingValues;

    RowWriter(StringBuilder buffer, int indentation, int maxValueLength, int maxValues, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        this.buffer = buffer;
        this.indentation = indentation;
        this.maxValueLength = maxValueLength;
        this.maxValues = maxValues;
        this.protocolVersion = protocolVersion;
        this.codecRegistry = codecRegistry;
        this.remainingValues = maxValues == -1 ? Integer.MAX_VALUE : maxValues;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public boolean maxAppendedValuesExceeded() {
        return this.remainingValues == -1;
    }

    public void newLine() {
        this.buffer.append(RowFormatterSymbols.lineSeparator);
    }

    public void indent() {
        for (int i = 0; i < this.indentation; ++i) {
            this.buffer.append(' ');
        }
    }

    @Override
    public RowWriter append(CharSequence csq) {
        this.buffer.append(csq);
        return this;
    }

    @Override
    public RowWriter append(CharSequence csq, int start, int end) {
        this.buffer.append(csq, start, end);
        return this;
    }

    @Override
    public RowWriter append(char c) {
        this.buffer.append(c);
        return this;
    }

    public RowWriter append(Object obj) {
        this.buffer.append(obj);
        return this;
    }

    public RowWriter append(String str) {
        this.buffer.append(str);
        return this;
    }

    public RowWriter appendClassNameAndHashCode(Row row) {
        String fqcn = row.getClass().getName();
        this.buffer.append(fqcn);
        this.buffer.append('@');
        this.buffer.append(Integer.toHexString(row.hashCode()));
        return this;
    }

    public void appendValue(String name, Object value, DataType type) {
        if (this.maxAppendedValuesExceeded()) {
            return;
        }
        if (value == null) {
            this.doAppendValue(name, "<NULL>");
            return;
        }
        if (value instanceof ByteBuffer && this.maxValueLength != -1) {
            boolean bufferLengthExceeded;
            ByteBuffer byteBuffer = (ByteBuffer)value;
            int maxBufferLengthInBytes = Math.max(2, this.maxValueLength / 2) - 1;
            boolean bl = bufferLengthExceeded = byteBuffer.remaining() > maxBufferLengthInBytes;
            if (bufferLengthExceeded) {
                byteBuffer = byteBuffer.duplicate();
                byteBuffer.limit(maxBufferLengthInBytes);
                String formatted = TypeCodecs.BLOB.format((Object)byteBuffer);
                this.doAppendValue(name, formatted);
                this.buffer.append("...");
                return;
            }
        }
        TypeCodec codec = type == null ? this.codecRegistry.codecFor(value) : this.codecRegistry.codecFor(type, value);
        this.doAppendValue(name, codec.format(value));
    }

    private void doAppendValue(String name, String value) {
        if (this.maxAppendedValuesExceeded()) {
            return;
        }
        if (this.remainingValues == 0) {
            this.buffer.append("...");
            this.remainingValues = -1;
            return;
        }
        boolean lengthExceeded = false;
        if (this.maxValueLength != -1 && value.length() > this.maxValueLength) {
            value = value.substring(0, this.maxValueLength);
            lengthExceeded = true;
        }
        if (name != null) {
            this.buffer.append(name);
            this.buffer.append(": ");
        }
        this.buffer.append(value);
        if (lengthExceeded) {
            this.buffer.append("...");
        }
        if (this.maxValues != -1) {
            --this.remainingValues;
        }
    }

    public String toString() {
        return this.buffer.toString();
    }
}

