/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.format.row;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.dsbulk.format.row.RowWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RowFormatter {
    public static final int UNLIMITED = -1;
    public static final int DEFAULT_MAX_VALUE_LENGTH = 50;
    public static final int DEFAULT_MAX_VALUES = 10;
    private static final Logger LOGGER = LoggerFactory.getLogger(RowFormatter.class);
    private final int maxValueLength;
    private final int maxValues;

    public RowFormatter() {
        this(50, 10);
    }

    public RowFormatter(int maxValueLength, int maxValues) {
        if (maxValueLength <= 0 && maxValueLength != -1) {
            throw new IllegalArgumentException("Invalid maxValueLength, should be > 0 or -1 (unlimited), got " + maxValueLength);
        }
        this.maxValueLength = maxValueLength;
        if (maxValues <= 0 && maxValues != -1) {
            throw new IllegalArgumentException("Invalid maxValues, should be > 0 or -1 (unlimited), got " + maxValues);
        }
        this.maxValues = maxValues;
    }

    public String format(Row row, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        try {
            RowWriter out = new RowWriter(new StringBuilder(), 0, this.maxValueLength, this.maxValues, protocolVersion, codecRegistry);
            this.print(row, out);
            return out.toString();
        }
        catch (Exception e) {
            try {
                LOGGER.error("Could not format row: " + row, (Throwable)e);
                return row.toString();
            }
            catch (Exception e1) {
                LOGGER.error("row.toString() failed", (Throwable)e1);
                return "row[?]";
            }
        }
    }

    protected void print(Row row, RowWriter out) {
        this.printHeader(row, out);
        this.printValues(row, out);
    }

    protected void printHeader(Row row, RowWriter out) {
        out.appendClassNameAndHashCode(row).append(" [").append(String.format("%s values", row.getColumnDefinitions().size())).append("]");
    }

    protected void printValues(Row row, RowWriter out) {
        ColumnDefinitions metadata;
        if (row.getColumnDefinitions().size() > 0 && (metadata = row.getColumnDefinitions()).size() > 0) {
            for (int i = 0; i < metadata.size(); ++i) {
                out.newLine();
                out.indent();
                ColumnDefinition col = metadata.get(i);
                String name = col.getName().asCql(true);
                DataType type = col.getType();
                Object value = null;
                boolean malformed = false;
                try {
                    value = row.getObject(i);
                }
                catch (Exception e) {
                    malformed = true;
                }
                if (malformed) {
                    out.appendValue(name, row.getBytesUnsafe(i), DataTypes.BLOB);
                    out.append(" (malformed buffer for type ").append(String.valueOf(type)).append(")");
                } else {
                    out.appendValue(name, value, type);
                }
                if (out.maxAppendedValuesExceeded()) break;
            }
        }
    }
}

