/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.writer;

import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.Uninterruptibles;
import com.datastax.oss.dsbulk.executor.api.exception.BulkExecutionException;
import com.datastax.oss.dsbulk.executor.api.result.WriteResult;
import com.datastax.oss.dsbulk.executor.api.writer.AsyncBulkWriter;
import com.datastax.oss.dsbulk.executor.api.writer.ReactiveBulkWriter;
import com.datastax.oss.dsbulk.executor.api.writer.SyncBulkWriter;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;

public interface BulkWriter
extends SyncBulkWriter,
AsyncBulkWriter,
ReactiveBulkWriter {
    @Override
    default public WriteResult writeSync(Statement<?> statement) throws BulkExecutionException {
        try {
            return (WriteResult)Uninterruptibles.getUninterruptibly(this.writeAsync(statement));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    @Override
    default public void writeSync(Publisher<? extends Statement<?>> statements, Consumer<? super WriteResult> consumer) throws BulkExecutionException {
        try {
            Uninterruptibles.getUninterruptibly(this.writeAsync(statements, consumer));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

