/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.writer;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.dsbulk.executor.api.exception.BulkExecutionException;
import com.datastax.oss.dsbulk.executor.api.result.WriteResult;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public interface AsyncBulkWriter
extends AutoCloseable {
    default public CompletableFuture<WriteResult> writeAsync(String statement) throws BulkExecutionException {
        return this.writeAsync((Statement<?>)SimpleStatement.newInstance((String)statement));
    }

    public CompletableFuture<WriteResult> writeAsync(Statement<?> var1) throws BulkExecutionException;

    default public CompletableFuture<Void> writeAsync(Stream<? extends Statement<?>> statements) throws BulkExecutionException {
        return this.writeAsync(statements, (? super WriteResult ignored) -> {});
    }

    public CompletableFuture<Void> writeAsync(Stream<? extends Statement<?>> var1, Consumer<? super WriteResult> var2) throws BulkExecutionException;

    default public CompletableFuture<Void> writeAsync(Iterable<? extends Statement<?>> statements) throws BulkExecutionException {
        return this.writeAsync(statements, (? super WriteResult ignored) -> {});
    }

    public CompletableFuture<Void> writeAsync(Iterable<? extends Statement<?>> var1, Consumer<? super WriteResult> var2) throws BulkExecutionException;

    default public CompletableFuture<Void> writeAsync(Publisher<? extends Statement<?>> statements) throws BulkExecutionException {
        return this.writeAsync(statements, (? super WriteResult ignored) -> {});
    }

    public CompletableFuture<Void> writeAsync(Publisher<? extends Statement<?>> var1, Consumer<? super WriteResult> var2);
}

