/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.subscription;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.RateLimiter;
import com.datastax.oss.dsbulk.executor.api.exception.BulkExecutionException;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionContext;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionListener;
import com.datastax.oss.dsbulk.executor.api.result.DefaultWriteResult;
import com.datastax.oss.dsbulk.executor.api.result.WriteResult;
import com.datastax.oss.dsbulk.executor.api.subscription.ResultSubscription;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Semaphore;
import org.reactivestreams.Subscriber;

public class WriteResultSubscription
extends ResultSubscription<WriteResult, AsyncResultSet> {
    public WriteResultSubscription(@NonNull Subscriber<? super WriteResult> subscriber, @NonNull Statement<?> statement, @Nullable ExecutionListener listener, @Nullable Semaphore maxConcurrentRequests, @Nullable RateLimiter rateLimiter, boolean failFast) {
        super(subscriber, statement, listener, maxConcurrentRequests, rateLimiter, failFast);
    }

    @Override
    ResultSubscription.Page toPage(AsyncResultSet rs, ExecutionContext local) {
        Iterator<DefaultWriteResult> iterator = Collections.singleton(new DefaultWriteResult(this.statement, rs)).iterator();
        return (ResultSubscription)this.new ResultSubscription.Page(iterator, null);
    }

    @Override
    WriteResult toErrorResult(BulkExecutionException error) {
        return new DefaultWriteResult(error);
    }

    @Override
    void onBeforeRequestStarted() {
        if (this.rateLimiter != null) {
            this.rateLimiter.acquire(this.batchSize);
        }
        super.onBeforeRequestStarted();
    }

    @Override
    void onRequestStarted(ExecutionContext local) {
        if (this.listener != null) {
            this.listener.onWriteRequestStarted(this.statement, local);
        }
    }

    @Override
    void onRequestSuccessful(AsyncResultSet rs, ExecutionContext local) {
        if (this.listener != null) {
            this.listener.onWriteRequestSuccessful(this.statement, local);
        }
    }

    @Override
    void onRequestFailed(Throwable t, ExecutionContext local) {
        if (this.listener != null) {
            this.listener.onWriteRequestFailed(this.statement, t, local);
        }
    }
}

