/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.result;

import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.dsbulk.executor.api.exception.BulkExecutionException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Optional;
import java.util.function.Consumer;

public interface Result {
    default public boolean isSuccess() {
        return !this.getError().isPresent();
    }

    @NonNull
    public Statement<?> getStatement();

    @NonNull
    public Optional<ExecutionInfo> getExecutionInfo();

    default public int getBatchSize() {
        return this.getStatement() instanceof BatchStatement ? ((BatchStatement)this.getStatement()).size() : 1;
    }

    @NonNull
    public Optional<BulkExecutionException> getError();

    default public void ifError(@NonNull Consumer<? super BulkExecutionException> consumer) {
        this.getError().ifPresent(consumer);
    }
}

