/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.result;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.dsbulk.executor.api.exception.BulkExecutionException;
import com.datastax.oss.dsbulk.executor.api.result.DefaultResult;
import com.datastax.oss.dsbulk.executor.api.result.WriteResult;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class DefaultWriteResult
extends DefaultResult
implements WriteResult {
    @Nullable
    private final AsyncResultSet rs;
    private final boolean wasApplied;

    public DefaultWriteResult(@NonNull Statement<?> statement, @NonNull AsyncResultSet rs) {
        super(statement, rs.getExecutionInfo());
        this.rs = rs;
        this.wasApplied = rs.wasApplied();
    }

    public DefaultWriteResult(@NonNull BulkExecutionException error) {
        super(error);
        this.rs = null;
        this.wasApplied = false;
    }

    @Override
    public boolean wasApplied() {
        return this.wasApplied;
    }

    @Override
    public Stream<? extends Row> getFailedWrites() {
        return this.rs == null || this.wasApplied ? Stream.empty() : StreamSupport.stream(this.rs.currentPage().spliterator(), false);
    }

    public String toString() {
        return "DefaultWriteResult[error=" + this.getError() + ", statement=" + this.getStatement() + ", executionInfo=" + this.getExecutionInfo() + ", wasApplied=" + this.wasApplied() + ']';
    }
}

