/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.result;

import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.dsbulk.executor.api.exception.BulkExecutionException;
import com.datastax.oss.dsbulk.executor.api.result.Result;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;

abstract class DefaultResult
implements Result {
    private final Statement<?> statement;
    private final ExecutionInfo executionInfo;
    private final BulkExecutionException error;

    protected DefaultResult(@NonNull Statement<?> statement, @NonNull ExecutionInfo executionInfo) {
        this.statement = statement;
        this.executionInfo = executionInfo;
        this.error = null;
    }

    protected DefaultResult(@NonNull BulkExecutionException error) {
        this.statement = error.getStatement();
        this.error = error;
        this.executionInfo = null;
    }

    @Override
    public boolean isSuccess() {
        return this.error == null;
    }

    @Override
    @NonNull
    public Statement<?> getStatement() {
        return this.statement;
    }

    @Override
    @NonNull
    public Optional<BulkExecutionException> getError() {
        return Optional.ofNullable(this.error);
    }

    @Override
    @NonNull
    public Optional<ExecutionInfo> getExecutionInfo() {
        return Optional.ofNullable(this.executionInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultResult)) {
            return false;
        }
        DefaultResult that = (DefaultResult)o;
        return this.statement.equals(that.statement) && Objects.equals(this.executionInfo, that.executionInfo) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        int result = this.statement.hashCode();
        result = 31 * result + (this.executionInfo != null ? this.executionInfo.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        return result;
    }
}

