/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.result;

import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.dsbulk.executor.api.exception.BulkExecutionException;
import com.datastax.oss.dsbulk.executor.api.result.DefaultResult;
import com.datastax.oss.dsbulk.executor.api.result.ReadResult;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;

public final class DefaultReadResult
extends DefaultResult
implements ReadResult {
    private final Row row;

    public DefaultReadResult(@NonNull Statement<?> statement, @NonNull ExecutionInfo executionInfo, @NonNull Row row) {
        super(statement, executionInfo);
        this.row = row;
    }

    public DefaultReadResult(@NonNull BulkExecutionException error) {
        super(error);
        this.row = null;
    }

    @Override
    @NonNull
    public Optional<Row> getRow() {
        return Optional.ofNullable(this.row);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultReadResult that = (DefaultReadResult)o;
        return Objects.equals(this.row, that.row);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.row != null ? this.row.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (!this.getError().isPresent()) assert (this.row != null);
        return "DefaultReadResult[row=" + this.getRow() + ", error=" + this.getError() + ", statement=" + this.getStatement() + ", executionInfo=" + this.getExecutionInfo() + ']';
    }
}

