/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.reader;

import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.Uninterruptibles;
import com.datastax.oss.dsbulk.executor.api.exception.BulkExecutionException;
import com.datastax.oss.dsbulk.executor.api.reader.AsyncBulkReader;
import com.datastax.oss.dsbulk.executor.api.reader.ReactiveBulkReader;
import com.datastax.oss.dsbulk.executor.api.reader.SyncBulkReader;
import com.datastax.oss.dsbulk.executor.api.result.ReadResult;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;

public interface BulkReader
extends SyncBulkReader,
AsyncBulkReader,
ReactiveBulkReader {
    @Override
    default public void readSync(Statement<?> statement, Consumer<? super ReadResult> consumer) throws BulkExecutionException {
        try {
            Uninterruptibles.getUninterruptibly(this.readAsync(statement, consumer));
        }
        catch (ExecutionException e) {
            throw (BulkExecutionException)e.getCause();
        }
    }

    @Override
    default public void readSync(Publisher<? extends Statement<?>> statements, Consumer<? super ReadResult> consumer) throws BulkExecutionException {
        try {
            Uninterruptibles.getUninterruptibly(this.readAsync(statements, consumer));
        }
        catch (ExecutionException e) {
            throw (BulkExecutionException)e.getCause();
        }
    }
}

