/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.publisher;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.RateLimiter;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionListener;
import com.datastax.oss.dsbulk.executor.api.result.WriteResult;
import com.datastax.oss.dsbulk.executor.api.subscription.WriteResultSubscription;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class WriteResultPublisher
implements Publisher<WriteResult> {
    private final Statement<?> statement;
    private final CqlSession session;
    @Nullable
    private final ExecutionListener listener;
    @Nullable
    private final Semaphore maxConcurrentRequests;
    @Nullable
    private final RateLimiter rateLimiter;
    private final boolean failFast;

    public WriteResultPublisher(@NonNull Statement<?> statement, @NonNull CqlSession session, boolean failFast) {
        this(statement, session, failFast, null, null, null);
    }

    public WriteResultPublisher(@NonNull Statement<?> statement, @NonNull CqlSession session, boolean failFast, @Nullable ExecutionListener listener, @Nullable Semaphore maxConcurrentRequests, @Nullable RateLimiter rateLimiter) {
        this.statement = statement;
        this.session = session;
        this.listener = listener;
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.rateLimiter = rateLimiter;
        this.failFast = failFast;
    }

    public void subscribe(Subscriber<? super WriteResult> subscriber) {
        Objects.requireNonNull(subscriber, "Subscriber cannot be null");
        WriteResultSubscription subscription = new WriteResultSubscription(subscriber, this.statement, this.listener, this.maxConcurrentRequests, this.rateLimiter, this.failFast);
        try {
            subscriber.onSubscribe((Subscription)subscription);
            subscription.start(() -> this.session.executeAsync(this.statement));
        }
        catch (Throwable t) {
            subscription.doOnError(new IllegalStateException(subscriber + " violated the Reactive Streams rule 2.13 by throwing an exception from onSubscribe.", t));
        }
    }
}

