/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.publisher;

import com.datastax.dse.driver.api.core.cql.continuous.ContinuousSession;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.RateLimiter;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionListener;
import com.datastax.oss.dsbulk.executor.api.result.ReadResult;
import com.datastax.oss.dsbulk.executor.api.subscription.ContinuousReadResultSubscription;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ContinuousReadResultPublisher
implements Publisher<ReadResult> {
    @NonNull
    private final Statement<?> statement;
    @NonNull
    private final ContinuousSession session;
    @Nullable
    private final ExecutionListener listener;
    @Nullable
    private final Semaphore maxConcurrentRequests;
    @Nullable
    private final RateLimiter rateLimiter;
    private final boolean failFast;

    public ContinuousReadResultPublisher(@NonNull Statement<?> statement, @NonNull ContinuousSession session, boolean failFast) {
        this(statement, session, failFast, null, null, null);
    }

    public ContinuousReadResultPublisher(@NonNull Statement<?> statement, @NonNull ContinuousSession session, boolean failFast, @Nullable ExecutionListener listener, @Nullable Semaphore maxConcurrentRequests, @Nullable RateLimiter rateLimiter) {
        this.statement = statement;
        this.session = session;
        this.listener = listener;
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.rateLimiter = rateLimiter;
        this.failFast = failFast;
    }

    public void subscribe(Subscriber<? super ReadResult> subscriber) {
        Objects.requireNonNull(subscriber, "Subscriber cannot be null");
        ContinuousReadResultSubscription subscription = new ContinuousReadResultSubscription(subscriber, this.statement, this.listener, this.maxConcurrentRequests, this.rateLimiter, this.failFast);
        try {
            subscriber.onSubscribe((Subscription)subscription);
            subscription.start(() -> this.session.executeContinuouslyAsync(this.statement));
        }
        catch (Throwable t) {
            subscription.doOnError(new IllegalStateException(subscriber + " violated the Reactive Streams rule 2.13 by throwing an exception from onSubscribe.", t));
        }
    }
}

