/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.listener;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.datastax.oss.dsbulk.executor.api.listener.AbstractMetricsReportingExecutionListener;
import com.datastax.oss.dsbulk.executor.api.listener.AbstractMetricsReportingExecutionListenerBuilder;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionListener;
import com.datastax.oss.dsbulk.executor.api.listener.LogSink;
import com.datastax.oss.dsbulk.executor.api.listener.MetricsCollectingExecutionListener;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadsAndWritesReportingExecutionListener
extends AbstractMetricsReportingExecutionListener
implements ExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadsAndWritesReportingExecutionListener.class);
    private static final LogSink DEFAULT_SINK = LogSink.buildFrom(() -> ((Logger)LOGGER).isInfoEnabled(), (arg_0, arg_1) -> ((Logger)LOGGER).info(arg_0, arg_1));
    private static final MetricFilter METRIC_FILTER = (name, metric) -> name.startsWith("executor/reads-writes/");
    private static final String REPORTER_NAME = "bulk-execution-reads-writes-reporter";
    private final long expectedTotal;
    private final String countMessage;
    private final String throughputMessage;
    private final String latencyMessage;
    private final Timer timer;
    private final Counter failed;
    private final Counter successful;
    private final Counter inFlight;
    @Nullable
    private final Meter sent;
    @Nullable
    private final Meter received;
    private final LogSink sink;

    public static AbstractMetricsReportingExecutionListenerBuilder<ReadsAndWritesReportingExecutionListener> builder() {
        return new AbstractMetricsReportingExecutionListenerBuilder<ReadsAndWritesReportingExecutionListener>(){

            @Override
            public ReadsAndWritesReportingExecutionListener build() {
                LogSink s;
                LogSink logSink = s = this.sink == null ? DEFAULT_SINK : this.sink;
                if (this.scheduler == null) {
                    return new ReadsAndWritesReportingExecutionListener(this.delegate, this.rateUnit, this.durationUnit, this.expectedTotal, s);
                }
                return new ReadsAndWritesReportingExecutionListener(this.delegate, this.rateUnit, this.durationUnit, this.expectedTotal, s, this.scheduler);
            }
        };
    }

    public ReadsAndWritesReportingExecutionListener() {
        this(new MetricsCollectingExecutionListener(), TimeUnit.SECONDS, TimeUnit.MILLISECONDS, -1L, DEFAULT_SINK);
    }

    public ReadsAndWritesReportingExecutionListener(MetricsCollectingExecutionListener delegate) {
        this(delegate, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, -1L, DEFAULT_SINK);
    }

    private ReadsAndWritesReportingExecutionListener(MetricsCollectingExecutionListener delegate, TimeUnit rateUnit, TimeUnit durationUnit, long expectedTotal, LogSink sink) {
        super(delegate, REPORTER_NAME, METRIC_FILTER, rateUnit, durationUnit);
        this.expectedTotal = expectedTotal;
        this.sink = sink;
        this.countMessage = ReadsAndWritesReportingExecutionListener.createCountMessageTemplate(expectedTotal);
        this.throughputMessage = ReadsAndWritesReportingExecutionListener.createThroughputMessageTemplate(delegate.getBytesSentMeter().isPresent() && delegate.getBytesReceivedMeter().isPresent());
        this.latencyMessage = ReadsAndWritesReportingExecutionListener.createLatencyMessageTemplate();
        this.timer = delegate.getTotalReadsWritesTimer();
        this.successful = delegate.getSuccessfulReadsWritesCounter();
        this.failed = delegate.getFailedReadsWritesCounter();
        this.inFlight = delegate.getInFlightRequestsCounter();
        this.sent = delegate.getBytesSentMeter().orElse(null);
        this.received = delegate.getBytesReceivedMeter().orElse(null);
    }

    private ReadsAndWritesReportingExecutionListener(MetricsCollectingExecutionListener delegate, TimeUnit rateUnit, TimeUnit durationUnit, long expectedTotal, LogSink sink, ScheduledExecutorService scheduler) {
        super(delegate, REPORTER_NAME, METRIC_FILTER, rateUnit, durationUnit, scheduler);
        this.expectedTotal = expectedTotal;
        this.sink = sink;
        this.countMessage = ReadsAndWritesReportingExecutionListener.createCountMessageTemplate(expectedTotal);
        this.throughputMessage = ReadsAndWritesReportingExecutionListener.createThroughputMessageTemplate(delegate.getBytesSentMeter().isPresent() && delegate.getBytesReceivedMeter().isPresent());
        this.latencyMessage = ReadsAndWritesReportingExecutionListener.createLatencyMessageTemplate();
        this.timer = delegate.getTotalReadsWritesTimer();
        this.successful = delegate.getSuccessfulReadsWritesCounter();
        this.failed = delegate.getFailedReadsWritesCounter();
        this.inFlight = delegate.getInFlightRequestsCounter();
        this.sent = delegate.getBytesSentMeter().orElse(null);
        this.received = delegate.getBytesReceivedMeter().orElse(null);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        if (!this.sink.isEnabled()) {
            return;
        }
        Snapshot snapshot = this.timer.getSnapshot();
        long total = this.timer.getCount();
        String durationUnit = this.getDurationUnit();
        String rateUnit = this.getRateUnit();
        if (this.expectedTotal < 0L) {
            this.sink.accept(String.format(this.countMessage, total, this.successful.getCount(), this.failed.getCount(), this.inFlight.getCount()), new Object[0]);
        } else {
            float achieved = (float)total / (float)this.expectedTotal * 100.0f;
            this.sink.accept(String.format(this.countMessage, total, this.successful.getCount(), this.failed.getCount(), this.inFlight.getCount(), Float.valueOf(achieved)), new Object[0]);
        }
        double throughput = this.timer.getMeanRate();
        if (this.sent != null && this.received != null) {
            double sizeSent = this.sent.getMeanRate();
            double sizeReceived = this.received.getMeanRate();
            this.sink.accept(String.format(this.throughputMessage, this.convertRate(throughput), rateUnit, this.convertRate(sizeSent / 1048576.0), rateUnit, this.convertRate(sizeReceived / 1048576.0), rateUnit, throughput == 0.0 ? 0.0 : sizeSent / 1024.0 / throughput, throughput == 0.0 ? 0.0 : sizeReceived / 1024.0 / throughput), new Object[0]);
        } else {
            this.sink.accept(String.format(this.throughputMessage, this.convertRate(throughput), rateUnit), new Object[0]);
        }
        this.sink.accept(String.format(this.latencyMessage, this.convertDuration(snapshot.getMean()), this.convertDuration(snapshot.get75thPercentile()), this.convertDuration(snapshot.get99thPercentile()), this.convertDuration(snapshot.get999thPercentile()), durationUnit), new Object[0]);
    }

    private static String createCountMessageTemplate(long expectedTotal) {
        if (expectedTotal < 0L) {
            return "Reads/Writes: total: %,d, successful: %,d, failed: %,d, in-flight: %,d";
        }
        int numDigits = String.format("%,d", expectedTotal).length();
        return "Reads/Writes: total: %," + numDigits + "d, successful: %," + numDigits + "d, failed: %,d, in-flight: %,d, progression: %,.0f%%";
    }

    private static String createThroughputMessageTemplate(boolean trackThroughputInBytes) {
        if (trackThroughputInBytes) {
            return "Throughput: %,.0f reads-writes/%s, %,.2f mb/%s sent, %,.2f mb/%s received (%,.3f kb/write, %,.3f kb/read)";
        }
        return "Throughput: %,.0f reads-writes/%s";
    }

    private static String createLatencyMessageTemplate() {
        return "Latencies: mean %,.2f, 75p %,.2f, 99p %,.2f, 999p %,.2f %s";
    }
}

