/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.listener;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.dsbulk.executor.api.exception.BulkExecutionException;
import com.datastax.oss.dsbulk.executor.api.histogram.HdrHistogramReservoir;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionContext;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionListener;
import com.datastax.oss.dsbulk.sampler.DataSizes;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class MetricsCollectingExecutionListener
implements ExecutionListener {
    private final MetricRegistry registry;
    private final Timer totalStatementsTimer;
    private final Counter successfulStatementsCounter;
    private final Counter failedStatementsCounter;
    private final Timer totalReadsTimer;
    private final Counter successfulReadsCounter;
    private final Counter failedReadsCounter;
    private final Timer totalWritesTimer;
    private final Counter successfulWritesCounter;
    private final Counter failedWritesCounter;
    private final Timer totalReadsWritesTimer;
    private final Counter successfulReadsWritesCounter;
    private final Counter failedReadsWritesCounter;
    private final Counter inFlightRequestsCounter;
    @Nullable
    private final Meter bytesReceivedMeter;
    @Nullable
    private final Meter bytesSentMeter;
    private final ProtocolVersion protocolVersion;
    private final CodecRegistry codecRegistry;

    public MetricsCollectingExecutionListener() {
        this(new MetricRegistry(), DseProtocolVersion.DEFAULT, CodecRegistry.DEFAULT, true);
    }

    public MetricsCollectingExecutionListener(MetricRegistry registry, ProtocolVersion protocolVersion, CodecRegistry codecRegistry, boolean trackThroughputInBytes) {
        this.registry = registry;
        this.protocolVersion = protocolVersion;
        this.codecRegistry = codecRegistry;
        this.totalStatementsTimer = registry.timer("executor/statements/total", () -> new Timer((Reservoir)new HdrHistogramReservoir()));
        this.successfulStatementsCounter = registry.counter("executor/statements/successful");
        this.failedStatementsCounter = registry.counter("executor/statements/failed");
        this.totalReadsTimer = registry.timer("executor/reads/total", () -> new Timer((Reservoir)new HdrHistogramReservoir()));
        this.successfulReadsCounter = registry.counter("executor/reads/successful");
        this.failedReadsCounter = registry.counter("executor/reads/failed");
        this.totalWritesTimer = registry.timer("executor/writes/total", () -> new Timer((Reservoir)new HdrHistogramReservoir()));
        this.successfulWritesCounter = registry.counter("executor/writes/successful");
        this.failedWritesCounter = registry.counter("executor/writes/failed");
        this.totalReadsWritesTimer = registry.timer("executor/reads-writes/total", () -> new Timer((Reservoir)new HdrHistogramReservoir()));
        this.successfulReadsWritesCounter = registry.counter("executor/reads-writes/successful");
        this.failedReadsWritesCounter = registry.counter("executor/reads-writes/failed");
        this.inFlightRequestsCounter = registry.counter("executor/in-flight");
        if (trackThroughputInBytes) {
            this.bytesSentMeter = registry.meter("executor/bytes/sent");
            this.bytesReceivedMeter = registry.meter("executor/bytes/received");
        } else {
            this.bytesSentMeter = null;
            this.bytesReceivedMeter = null;
        }
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public Timer getTotalStatementsTimer() {
        return this.totalStatementsTimer;
    }

    public Counter getSuccessfulStatementsCounter() {
        return this.successfulStatementsCounter;
    }

    public Counter getFailedStatementsCounter() {
        return this.failedStatementsCounter;
    }

    public Timer getTotalReadsTimer() {
        return this.totalReadsTimer;
    }

    public Counter getSuccessfulReadsCounter() {
        return this.successfulReadsCounter;
    }

    public Counter getFailedReadsCounter() {
        return this.failedReadsCounter;
    }

    public Timer getTotalWritesTimer() {
        return this.totalWritesTimer;
    }

    public Counter getSuccessfulWritesCounter() {
        return this.successfulWritesCounter;
    }

    public Counter getFailedWritesCounter() {
        return this.failedWritesCounter;
    }

    public Timer getTotalReadsWritesTimer() {
        return this.totalReadsWritesTimer;
    }

    public Counter getSuccessfulReadsWritesCounter() {
        return this.successfulReadsWritesCounter;
    }

    public Counter getFailedReadsWritesCounter() {
        return this.failedReadsWritesCounter;
    }

    public Counter getInFlightRequestsCounter() {
        return this.inFlightRequestsCounter;
    }

    public Optional<Meter> getBytesSentMeter() {
        return Optional.ofNullable(this.bytesSentMeter);
    }

    public Optional<Meter> getBytesReceivedMeter() {
        return Optional.ofNullable(this.bytesReceivedMeter);
    }

    @Override
    public void onWriteRequestStarted(Statement<?> statement, ExecutionContext context) {
        if (this.bytesSentMeter != null) {
            long size = DataSizes.getDataSize(statement, (ProtocolVersion)this.protocolVersion, (CodecRegistry)this.codecRegistry);
            this.bytesSentMeter.mark(size);
        }
        this.inFlightRequestsCounter.inc();
    }

    @Override
    public void onReadRequestStarted(Statement<?> statement, ExecutionContext context) {
        this.inFlightRequestsCounter.inc();
    }

    @Override
    public void onWriteRequestSuccessful(Statement<?> statement, ExecutionContext context) {
        int delta = MetricsCollectingExecutionListener.delta(statement);
        MetricsCollectingExecutionListener.stop(context, this.totalWritesTimer, delta);
        MetricsCollectingExecutionListener.stop(context, this.totalReadsWritesTimer, delta);
        this.successfulWritesCounter.inc((long)delta);
        this.successfulReadsWritesCounter.inc((long)delta);
        this.inFlightRequestsCounter.dec();
    }

    @Override
    public void onWriteRequestFailed(Statement<?> statement, Throwable error, ExecutionContext context) {
        int delta = MetricsCollectingExecutionListener.delta(statement);
        MetricsCollectingExecutionListener.stop(context, this.totalWritesTimer, delta);
        MetricsCollectingExecutionListener.stop(context, this.totalReadsWritesTimer, delta);
        this.failedWritesCounter.inc((long)delta);
        this.failedReadsWritesCounter.inc((long)delta);
        this.inFlightRequestsCounter.dec();
    }

    @Override
    public void onReadRequestSuccessful(Statement<?> statement, ExecutionContext context) {
        this.inFlightRequestsCounter.dec();
    }

    @Override
    public void onRowReceived(Row row, ExecutionContext context) {
        MetricsCollectingExecutionListener.stop(context, this.totalReadsTimer, 1);
        MetricsCollectingExecutionListener.stop(context, this.totalReadsWritesTimer, 1);
        this.successfulReadsCounter.inc(1L);
        this.successfulReadsWritesCounter.inc(1L);
        if (this.bytesReceivedMeter != null) {
            long size = DataSizes.getDataSize((Row)row);
            this.bytesReceivedMeter.mark(size);
        }
    }

    @Override
    public void onReadRequestFailed(Statement<?> statement, Throwable error, ExecutionContext context) {
        MetricsCollectingExecutionListener.stop(context, this.totalReadsTimer, 1);
        MetricsCollectingExecutionListener.stop(context, this.totalReadsWritesTimer, 1);
        this.failedReadsCounter.inc();
        this.failedReadsWritesCounter.inc();
        this.inFlightRequestsCounter.dec();
    }

    @Override
    public void onExecutionSuccessful(Statement<?> statement, ExecutionContext context) {
        MetricsCollectingExecutionListener.stop(context, this.totalStatementsTimer, 1);
        this.successfulStatementsCounter.inc();
    }

    @Override
    public void onExecutionFailed(BulkExecutionException exception, ExecutionContext context) {
        MetricsCollectingExecutionListener.stop(context, this.totalStatementsTimer, 1);
        this.failedStatementsCounter.inc();
    }

    private static void stop(ExecutionContext context, Timer timer, int delta) {
        long elapsed = context.elapsedTimeNanos();
        for (int i = 0; i < delta; ++i) {
            timer.update(elapsed, TimeUnit.NANOSECONDS);
        }
    }

    private static int delta(Statement<?> statement) {
        if (statement instanceof BatchStatement) {
            return ((BatchStatement)statement).size();
        }
        return 1;
    }
}

