/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.listener;

import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.dsbulk.executor.api.exception.BulkExecutionException;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionContext;

public interface ExecutionListener {
    default public void onExecutionStarted(Statement<?> statement, ExecutionContext context) {
    }

    default public void onWriteRequestStarted(Statement<?> statement, ExecutionContext context) {
    }

    default public void onWriteRequestSuccessful(Statement<?> statement, ExecutionContext context) {
    }

    default public void onWriteRequestFailed(Statement<?> statement, Throwable error, ExecutionContext context) {
    }

    default public void onReadRequestStarted(Statement<?> statement, ExecutionContext context) {
    }

    default public void onReadRequestSuccessful(Statement<?> statement, ExecutionContext context) {
    }

    default public void onRowReceived(Row row, ExecutionContext context) {
    }

    default public void onReadRequestFailed(Statement<?> statement, Throwable error, ExecutionContext context) {
    }

    default public void onExecutionSuccessful(Statement<?> statement, ExecutionContext context) {
    }

    default public void onExecutionFailed(BulkExecutionException exception, ExecutionContext context) {
    }
}

