/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.listener;

import com.datastax.oss.dsbulk.executor.api.listener.ExecutionContext;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.jctools.maps.NonBlockingHashMap;

public class DefaultExecutionContext
implements ExecutionContext {
    private volatile ConcurrentMap<Object, Object> attributes = null;
    private volatile long start = -1L;
    private volatile long end = -1L;

    @Override
    public void setAttribute(Object key, Object value) {
        this.getAttributes().put(key, value);
    }

    @Override
    public Optional<Object> getAttribute(Object key) {
        return Optional.ofNullable(this.getAttributes().get(key));
    }

    @Override
    public long elapsedTimeNanos() {
        return this.start == -1L || this.end == -1L ? -1L : this.end - this.start;
    }

    public void start() {
        this.start = System.nanoTime();
    }

    public void stop() {
        this.end = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<Object, Object> getAttributes() {
        if (this.attributes == null) {
            DefaultExecutionContext defaultExecutionContext = this;
            synchronized (defaultExecutionContext) {
                if (this.attributes == null) {
                    NonBlockingHashMap attributes;
                    this.attributes = attributes = new NonBlockingHashMap();
                }
            }
        }
        return this.attributes;
    }
}

