/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.listener;

import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.dsbulk.executor.api.exception.BulkExecutionException;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionContext;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionListener;
import java.util.Arrays;
import java.util.List;

public class CompositeExecutionListener
implements ExecutionListener {
    private final List<ExecutionListener> listeners;

    public CompositeExecutionListener(ExecutionListener ... listeners) {
        this(Arrays.asList(listeners));
    }

    public CompositeExecutionListener(Iterable<ExecutionListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
    }

    @Override
    public void onExecutionStarted(Statement<?> statement, ExecutionContext context) {
        this.listeners.forEach(l -> l.onExecutionStarted(statement, context));
    }

    @Override
    public void onExecutionSuccessful(Statement<?> statement, ExecutionContext context) {
        this.listeners.forEach(l -> l.onExecutionSuccessful(statement, context));
    }

    @Override
    public void onExecutionFailed(BulkExecutionException exception, ExecutionContext context) {
        this.listeners.forEach(l -> l.onExecutionFailed(exception, context));
    }

    @Override
    public void onWriteRequestStarted(Statement<?> statement, ExecutionContext context) {
        this.listeners.forEach(l -> l.onWriteRequestStarted(statement, context));
    }

    @Override
    public void onWriteRequestSuccessful(Statement<?> statement, ExecutionContext context) {
        this.listeners.forEach(l -> l.onWriteRequestSuccessful(statement, context));
    }

    @Override
    public void onWriteRequestFailed(Statement<?> statement, Throwable error, ExecutionContext context) {
        this.listeners.forEach(l -> l.onWriteRequestFailed(statement, error, context));
    }

    @Override
    public void onReadRequestStarted(Statement<?> statement, ExecutionContext context) {
        this.listeners.forEach(l -> l.onReadRequestStarted(statement, context));
    }

    @Override
    public void onReadRequestSuccessful(Statement<?> statement, ExecutionContext context) {
        this.listeners.forEach(l -> l.onReadRequestSuccessful(statement, context));
    }

    @Override
    public void onReadRequestFailed(Statement<?> statement, Throwable error, ExecutionContext context) {
        this.listeners.forEach(l -> l.onReadRequestFailed(statement, error, context));
    }

    @Override
    public void onRowReceived(Row row, ExecutionContext context) {
        this.listeners.forEach(l -> l.onRowReceived(row, context));
    }
}

