/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.listener;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.dsbulk.executor.api.listener.AbstractMetricsReportingExecutionListener;
import com.datastax.oss.dsbulk.executor.api.listener.LogSink;
import com.datastax.oss.dsbulk.executor.api.listener.MetricsCollectingExecutionListener;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AbstractMetricsReportingExecutionListenerBuilder<T extends AbstractMetricsReportingExecutionListener> {
    MetricsCollectingExecutionListener delegate;
    long expectedTotal = -1L;
    TimeUnit rateUnit = TimeUnit.SECONDS;
    TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    ScheduledExecutorService scheduler;
    LogSink sink;

    AbstractMetricsReportingExecutionListenerBuilder() {
    }

    public AbstractMetricsReportingExecutionListenerBuilder<T> extractingMetricsFrom(MetricsCollectingExecutionListener delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        return this;
    }

    public AbstractMetricsReportingExecutionListenerBuilder<T> expectingTotalEvents(long expectedTotal) {
        Preconditions.checkArgument((expectedTotal > 0L ? 1 : 0) != 0);
        this.expectedTotal = expectedTotal;
        return this;
    }

    public AbstractMetricsReportingExecutionListenerBuilder<T> convertRatesTo(TimeUnit rateUnit) {
        this.rateUnit = rateUnit;
        return this;
    }

    public AbstractMetricsReportingExecutionListenerBuilder<T> convertDurationsTo(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
        return this;
    }

    public AbstractMetricsReportingExecutionListenerBuilder<T> withScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public AbstractMetricsReportingExecutionListenerBuilder<T> withLogSink(LogSink sink) {
        this.sink = sink;
        return this;
    }

    public abstract T build();
}

