/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.listener;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.ScheduledReporter;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.dsbulk.executor.api.exception.BulkExecutionException;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionContext;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionListener;
import com.datastax.oss.dsbulk.executor.api.listener.MetricsCollectingExecutionListener;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AbstractMetricsReportingExecutionListener
extends ScheduledReporter
implements ExecutionListener {
    protected static final double BYTES_PER_KB = 1024.0;
    protected static final double BYTES_PER_MB = 1048576.0;
    private final MetricsCollectingExecutionListener delegate;

    protected AbstractMetricsReportingExecutionListener(MetricsCollectingExecutionListener delegate, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        super(delegate.getRegistry(), name, filter, rateUnit, durationUnit);
        this.delegate = delegate;
    }

    protected AbstractMetricsReportingExecutionListener(MetricsCollectingExecutionListener delegate, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, ScheduledExecutorService scheduler) {
        super(delegate.getRegistry(), name, filter, rateUnit, durationUnit, scheduler);
        this.delegate = delegate;
    }

    @Override
    public void onExecutionStarted(Statement<?> statement, ExecutionContext context) {
        this.delegate.onExecutionStarted(statement, context);
    }

    @Override
    public void onWriteRequestStarted(Statement<?> statement, ExecutionContext context) {
        this.delegate.onWriteRequestStarted(statement, context);
    }

    @Override
    public void onReadRequestStarted(Statement<?> statement, ExecutionContext context) {
        this.delegate.onReadRequestStarted(statement, context);
    }

    @Override
    public void onWriteRequestSuccessful(Statement<?> statement, ExecutionContext context) {
        this.delegate.onWriteRequestSuccessful(statement, context);
    }

    @Override
    public void onWriteRequestFailed(Statement<?> statement, Throwable error, ExecutionContext context) {
        this.delegate.onWriteRequestFailed(statement, error, context);
    }

    @Override
    public void onReadRequestSuccessful(Statement<?> statement, ExecutionContext context) {
        this.delegate.onReadRequestSuccessful(statement, context);
    }

    @Override
    public void onRowReceived(Row row, ExecutionContext context) {
        this.delegate.onRowReceived(row, context);
    }

    @Override
    public void onReadRequestFailed(Statement<?> statement, Throwable error, ExecutionContext context) {
        this.delegate.onReadRequestFailed(statement, error, context);
    }

    @Override
    public void onExecutionSuccessful(Statement<?> statement, ExecutionContext context) {
        this.delegate.onExecutionSuccessful(statement, context);
    }

    @Override
    public void onExecutionFailed(BulkExecutionException exception, ExecutionContext context) {
        this.delegate.onExecutionFailed(exception, context);
    }
}

