/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.histogram;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.datastax.oss.dsbulk.executor.api.histogram.HdrHistogramSnapshot;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;

public class HdrHistogramReservoir
implements Reservoir {
    private final Recorder recorder;
    private final Histogram runningTotals;
    private Histogram intervalHistogram;

    public HdrHistogramReservoir() {
        this(new Recorder(2));
    }

    public HdrHistogramReservoir(Recorder recorder) {
        this.recorder = recorder;
        this.intervalHistogram = recorder.getIntervalHistogram();
        this.runningTotals = new Histogram(this.intervalHistogram.getNumberOfSignificantValueDigits());
    }

    public int size() {
        return this.getSnapshot().size();
    }

    public void update(long value) {
        this.recorder.recordValue(value);
    }

    public Snapshot getSnapshot() {
        return new HdrHistogramSnapshot(this.updateRunningTotals());
    }

    private synchronized Histogram updateRunningTotals() {
        this.intervalHistogram = this.recorder.getIntervalHistogram(this.intervalHistogram);
        this.runningTotals.add((AbstractHistogram)this.intervalHistogram);
        return this.runningTotals.copy();
    }
}

