/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api.exception;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;

public class BulkExecutionException
extends RuntimeException {
    private final Statement<?> statement;

    public BulkExecutionException(Throwable cause, Statement<?> statement) {
        super(cause);
        this.statement = statement;
    }

    @Override
    public String getMessage() {
        if (this.statement instanceof SimpleStatement) {
            return String.format("Statement execution failed: %s (%s)", ((SimpleStatement)this.statement).getQuery(), this.getCause().getMessage());
        }
        if (this.statement instanceof BoundStatement) {
            return String.format("Statement execution failed: %s (%s)", ((BoundStatement)this.statement).getPreparedStatement().getQuery(), this.getCause().getMessage());
        }
        return String.format("Statement execution failed (%s)", this.getCause().getMessage());
    }

    public Statement<?> getStatement() {
        return this.statement;
    }
}

