/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.dsbulk.executor.api.BulkExecutor;
import com.datastax.oss.dsbulk.executor.api.BulkExecutorBuilder;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionListener;

public abstract class AbstractBulkExecutorBuilder<T extends BulkExecutor>
implements BulkExecutorBuilder<T> {
    protected final CqlSession session;
    protected boolean failFast = true;
    protected int maxInFlightRequests = 1000;
    protected int maxRequestsPerSecond = 100000;
    protected ExecutionListener listener;

    protected AbstractBulkExecutorBuilder(CqlSession session) {
        this.session = session;
    }

    @Override
    public AbstractBulkExecutorBuilder<T> failSafe() {
        this.failFast = false;
        return this;
    }

    @Override
    public AbstractBulkExecutorBuilder<T> withMaxInFlightRequests(int maxInFlightRequests) {
        this.maxInFlightRequests = maxInFlightRequests;
        return this;
    }

    @Override
    public AbstractBulkExecutorBuilder<T> withMaxRequestsPerSecond(int maxRequestsPerSecond) {
        this.maxRequestsPerSecond = maxRequestsPerSecond;
        return this;
    }

    @Override
    public AbstractBulkExecutorBuilder<T> withExecutionListener(ExecutionListener listener) {
        this.listener = listener;
        return this;
    }
}

