/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.executor.api;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.RateLimiter;
import com.datastax.oss.dsbulk.executor.api.AbstractBulkExecutorBuilder;
import com.datastax.oss.dsbulk.executor.api.BulkExecutor;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionListener;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.Semaphore;

public abstract class AbstractBulkExecutor
implements BulkExecutor,
AutoCloseable {
    static final int DEFAULT_MAX_IN_FLIGHT_REQUESTS = 1000;
    static final int DEFAULT_MAX_REQUESTS_PER_SECOND = 100000;
    @NonNull
    protected final CqlSession session;
    protected final boolean failFast;
    @Nullable
    protected final Semaphore maxConcurrentRequests;
    @Nullable
    protected final RateLimiter rateLimiter;
    @Nullable
    protected final ExecutionListener listener;

    protected AbstractBulkExecutor(CqlSession session) {
        this(session, true, 1000, 100000, null);
    }

    protected AbstractBulkExecutor(AbstractBulkExecutorBuilder<?> builder) {
        this(builder.session, builder.failFast, builder.maxInFlightRequests, builder.maxRequestsPerSecond, builder.listener);
    }

    private AbstractBulkExecutor(@NonNull CqlSession session, boolean failFast, int maxInFlightRequests, int maxRequestsPerSecond, @Nullable ExecutionListener listener) {
        Objects.requireNonNull(session, "session cannot be null");
        this.session = session;
        this.failFast = failFast;
        this.maxConcurrentRequests = maxInFlightRequests <= 0 ? null : new Semaphore(maxInFlightRequests);
        this.rateLimiter = maxRequestsPerSecond <= 0 ? null : RateLimiter.create((double)maxRequestsPerSecond);
        this.listener = listener;
    }

    @Override
    public void close() {
    }
}

