/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.connectors.csv;

import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.datastax.oss.dsbulk.connectors.api.CommonConnectorFeature;
import com.datastax.oss.dsbulk.connectors.api.ConnectorFeature;
import com.datastax.oss.dsbulk.connectors.api.DefaultErrorRecord;
import com.datastax.oss.dsbulk.connectors.api.DefaultIndexedField;
import com.datastax.oss.dsbulk.connectors.api.DefaultMappedField;
import com.datastax.oss.dsbulk.connectors.api.DefaultRecord;
import com.datastax.oss.dsbulk.connectors.api.Field;
import com.datastax.oss.dsbulk.connectors.api.MappedField;
import com.datastax.oss.dsbulk.connectors.api.RecordMetadata;
import com.datastax.oss.dsbulk.connectors.commons.AbstractFileBasedConnector;
import com.datastax.oss.dsbulk.io.CompressedIOUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.TextParsingException;
import com.univocity.parsers.common.TextWritingException;
import com.univocity.parsers.common.record.Record;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.SynchronousSink;

public class CSVConnector
extends AbstractFileBasedConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVConnector.class);
    private static final GenericType<String> STRING_TYPE = GenericType.STRING;
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final String DELIMITER = "delimiter";
    private static final String QUOTE = "quote";
    private static final String ESCAPE = "escape";
    private static final String COMMENT = "comment";
    private static final String NEWLINE = "newline";
    private static final String HEADER = "header";
    private static final String MAX_CHARS_PER_COLUMN = "maxCharsPerColumn";
    private static final String MAX_COLUMNS = "maxColumns";
    private static final String AUTO_NEWLINE = "auto";
    private static final String IGNORE_LEADING_WHITESPACES = "ignoreLeadingWhitespaces";
    private static final String IGNORE_TRAILING_WHITESPACES = "ignoreTrailingWhitespaces";
    private static final String IGNORE_LEADING_WHITESPACES_IN_QUOTES = "ignoreLeadingWhitespacesInQuotes";
    private static final String IGNORE_TRAILING_WHITESPACES_IN_QUOTES = "ignoreTrailingWhitespacesInQuotes";
    private static final String NORMALIZE_LINE_ENDINGS_IN_QUOTES = "normalizeLineEndingsInQuotes";
    private static final String NULL_VALUE = "nullValue";
    private static final String EMPTY_VALUE = "emptyValue";
    private static final String AUTO = "AUTO";
    private String delimiter;
    private char quote;
    private char escape;
    private char comment;
    private String newline;
    private boolean header;
    private int maxCharsPerColumn;
    private int maxColumns;
    private boolean ignoreLeadingWhitespaces;
    private boolean ignoreTrailingWhitespaces;
    private boolean ignoreTrailingWhitespacesInQuotes;
    private boolean ignoreLeadingWhitespacesInQuotes;
    private boolean normalizeLineEndingsInQuotes;
    private String nullValue;
    private String emptyValue;
    private CsvParserSettings parserSettings;
    private CsvWriterSettings writerSettings;

    @NonNull
    public String getConnectorName() {
        return "csv";
    }

    public void configure(@NonNull Config settings, boolean read, boolean retainRecordSources) {
        try {
            super.configure(settings, read, retainRecordSources);
            this.delimiter = settings.getString(DELIMITER);
            if (this.delimiter.isEmpty()) {
                throw new IllegalArgumentException(String.format("Invalid value for dsbulk.connector.csv.%s: Expecting non-empty string", DELIMITER));
            }
            this.quote = ConfigUtils.getChar((Config)settings, (String)QUOTE);
            this.escape = ConfigUtils.getChar((Config)settings, (String)ESCAPE);
            this.comment = ConfigUtils.getChar((Config)settings, (String)COMMENT);
            this.header = settings.getBoolean(HEADER);
            this.maxCharsPerColumn = settings.getInt(MAX_CHARS_PER_COLUMN);
            this.maxColumns = settings.getInt(MAX_COLUMNS);
            this.newline = settings.getString(NEWLINE);
            this.ignoreLeadingWhitespaces = settings.getBoolean(IGNORE_LEADING_WHITESPACES);
            this.ignoreTrailingWhitespaces = settings.getBoolean(IGNORE_TRAILING_WHITESPACES);
            this.ignoreLeadingWhitespacesInQuotes = settings.getBoolean(IGNORE_LEADING_WHITESPACES_IN_QUOTES);
            this.ignoreTrailingWhitespacesInQuotes = settings.getBoolean(IGNORE_TRAILING_WHITESPACES_IN_QUOTES);
            this.normalizeLineEndingsInQuotes = settings.getBoolean(NORMALIZE_LINE_ENDINGS_IN_QUOTES);
            this.nullValue = settings.getIsNull(NULL_VALUE) ? null : settings.getString(NULL_VALUE);
            String string = this.emptyValue = settings.getIsNull(EMPTY_VALUE) ? null : settings.getString(EMPTY_VALUE);
            if (!AUTO_NEWLINE.equalsIgnoreCase(this.newline) && (this.newline.isEmpty() || this.newline.length() > 2)) {
                throw new IllegalArgumentException(String.format("Invalid value for dsbulk.connector.csv.%s: Expecting '%s' or a string containing 1 or 2 chars, got: '%s'", NEWLINE, AUTO_NEWLINE, this.newline));
            }
        }
        catch (ConfigException e) {
            throw ConfigUtils.convertConfigException((ConfigException)e, (String)"dsbulk.connector.csv");
        }
    }

    public void init() throws URISyntaxException, IOException {
        super.init();
        CsvFormat format = new CsvFormat();
        format.setDelimiter(this.delimiter);
        format.setQuote(this.quote);
        format.setQuoteEscape(this.escape);
        format.setComment(this.comment);
        boolean autoNewline = AUTO_NEWLINE.equalsIgnoreCase(this.newline);
        if (this.read) {
            this.parserSettings = new CsvParserSettings();
            this.parserSettings.setFormat((Format)format);
            this.parserSettings.setNullValue(AUTO.equalsIgnoreCase(this.nullValue) ? null : this.nullValue);
            this.parserSettings.setEmptyValue(AUTO.equalsIgnoreCase(this.emptyValue) ? "" : this.emptyValue);
            this.parserSettings.setHeaderExtractionEnabled(this.header);
            this.parserSettings.setMaxCharsPerColumn(this.maxCharsPerColumn);
            this.parserSettings.setMaxColumns(this.maxColumns);
            this.parserSettings.setNormalizeLineEndingsWithinQuotes(this.normalizeLineEndingsInQuotes);
            this.parserSettings.setIgnoreLeadingWhitespaces(this.ignoreLeadingWhitespaces);
            this.parserSettings.setIgnoreTrailingWhitespaces(this.ignoreTrailingWhitespaces);
            this.parserSettings.setIgnoreLeadingWhitespacesInQuotes(this.ignoreLeadingWhitespacesInQuotes);
            this.parserSettings.setIgnoreTrailingWhitespacesInQuotes(this.ignoreTrailingWhitespacesInQuotes);
            if (autoNewline) {
                this.parserSettings.setLineSeparatorDetectionEnabled(true);
            } else {
                format.setLineSeparator(this.newline);
            }
        } else {
            this.writerSettings = new CsvWriterSettings();
            this.writerSettings.setFormat((Format)format);
            this.writerSettings.setNullValue(AUTO.equalsIgnoreCase(this.nullValue) ? null : this.nullValue);
            this.writerSettings.setEmptyValue(AUTO.equalsIgnoreCase(this.emptyValue) ? "" + this.quote + this.quote : this.emptyValue);
            this.writerSettings.setQuoteEscapingEnabled(true);
            this.writerSettings.setIgnoreLeadingWhitespaces(this.ignoreLeadingWhitespaces);
            this.writerSettings.setIgnoreTrailingWhitespaces(this.ignoreTrailingWhitespaces);
            this.writerSettings.setMaxColumns(this.maxColumns);
            this.writerSettings.setNormalizeLineEndingsWithinQuotes(this.normalizeLineEndingsInQuotes);
            if (autoNewline) {
                format.setLineSeparator(System.lineSeparator());
            } else {
                format.setLineSeparator(this.newline);
            }
        }
    }

    @NonNull
    public RecordMetadata getRecordMetadata() {
        return (field, cqlType) -> STRING_TYPE;
    }

    public boolean supports(@NonNull ConnectorFeature feature) {
        if (feature instanceof CommonConnectorFeature) {
            CommonConnectorFeature commonFeature = (CommonConnectorFeature)feature;
            switch (commonFeature) {
                case MAPPED_RECORDS: {
                    return this.header;
                }
                case INDEXED_RECORDS: {
                    return true;
                }
                case DATA_SIZE_SAMPLING: {
                    return this.isDataSizeSamplingAvailable();
                }
            }
        }
        return false;
    }

    @NonNull
    protected AbstractFileBasedConnector.RecordReader newSingleFileReader(@NonNull URL url) throws IOException {
        return new CSVRecordReader(url);
    }

    @NonNull
    protected AbstractFileBasedConnector.RecordWriter newSingleFileWriter() {
        return new CSVRecordWriter();
    }

    @NonNull
    private IOException asIOException(@NonNull URL url, Exception e, String genericErrorMessage) {
        IOException error = e instanceof TextParsingException ? this.launderTextParsingException((TextParsingException)e, url) : (e.getCause() instanceof TextParsingException ? this.launderTextParsingException((TextParsingException)e.getCause(), url) : new IOException(genericErrorMessage, e));
        return error;
    }

    private IOException launderTextParsingException(TextParsingException e, URL url) {
        String message = e.getMessage();
        int i = message.indexOf(10);
        if (i != -1) {
            message = message.substring(0, i);
        }
        if (e.getCause() instanceof ArrayIndexOutOfBoundsException) {
            message = message.matches("Length of parsed input \\(\\d+\\) exceeds the maximum number of characters defined in your parser settings.*") ? message + "Please increase the value of the connector.csv.maxCharsPerColumn setting." : message + String.format(". The  maximum number of columns per record (%d) was exceeded. Please increase the value of the connector.csv.maxColumns setting.", this.maxColumns);
        }
        return new IOException(String.format("Error reading from %s at line %d: %s", url, e.getLineIndex(), message), (Throwable)e);
    }

    private class CSVRecordWriter
    implements AbstractFileBasedConnector.RecordWriter {
        private URL url;
        private CsvWriter writer;

        private CSVRecordWriter() {
        }

        public void write(@NonNull com.datastax.oss.dsbulk.connectors.api.Record record) throws IOException {
            block6: {
                try {
                    if (this.writer == null) {
                        this.open();
                    } else if (this.shouldRoll()) {
                        this.close();
                        this.open();
                    }
                    if (this.shouldWriteHeader()) {
                        this.writer.writeHeaders((String[])record.fields().stream().map(Object::toString).toArray(String[]::new));
                    }
                    LOGGER.trace("Writing record {} to {}", (Object)record, (Object)this.url);
                    this.writer.writeRow(record.values());
                }
                catch (TextWritingException e) {
                    if (e.getCause() instanceof ClosedChannelException) break block6;
                    throw new IOException(String.format("Error writing to %s", this.url), e);
                }
            }
        }

        private boolean shouldWriteHeader() {
            return CSVConnector.this.header && this.writer.getRecordCount() == 0L;
        }

        private boolean shouldRoll() {
            return !CSVConnector.this.roots.isEmpty() && this.writer.getRecordCount() == CSVConnector.this.maxRecords;
        }

        private void open() throws IOException {
            this.url = CSVConnector.this.getOrCreateDestinationURL();
            try {
                this.writer = new CsvWriter((Writer)CompressedIOUtils.newBufferedWriter((URL)this.url, (Charset)CSVConnector.this.encoding, (String)CSVConnector.this.compression), CSVConnector.this.writerSettings);
                LOGGER.debug("Writing {}", (Object)this.url);
            }
            catch (ClosedChannelException closedChannelException) {
            }
            catch (IOException | RuntimeException e) {
                throw new IOException(String.format("Error opening %s", this.url), e);
            }
        }

        public void flush() throws IOException {
            if (this.writer != null) {
                try {
                    this.writer.flush();
                }
                catch (RuntimeException e) {
                    throw new IOException(String.format("Error flushing %s", this.url), e);
                }
            }
        }

        public void close() throws IOException {
            block3: {
                if (this.writer != null) {
                    try {
                        this.writer.close();
                        LOGGER.debug("Done writing {}", (Object)this.url);
                        this.writer = null;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof ClosedChannelException) break block3;
                        throw new IOException(String.format("Error closing %s", this.url), e.getCause());
                    }
                }
            }
        }
    }

    private class CSVRecordReader
    implements AbstractFileBasedConnector.RecordReader {
        private final URL url;
        private final URI resource;
        private final CsvParser parser;
        private final ParsingContext context;
        private final MappedField[] fieldNames;
        private long recordNumber = 1L;

        private CSVRecordReader(URL url) throws IOException {
            this.url = url;
            try {
                this.resource = URI.create(url.toExternalForm());
                this.parser = new CsvParser(CSVConnector.this.parserSettings);
                BufferedReader r = CompressedIOUtils.newBufferedReader((URL)url, (Charset)CSVConnector.this.encoding, (String)CSVConnector.this.compression);
                this.parser.beginParsing((Reader)r);
                this.context = this.parser.getContext();
                this.fieldNames = CSVConnector.this.header ? this.getFieldNames(url, this.context) : null;
            }
            catch (Exception e) {
                throw CSVConnector.this.asIOException(url, e, "Error creating CSV parser for " + url);
            }
        }

        private MappedField[] getFieldNames(URL url, ParsingContext context) throws IOException {
            ArrayList<String> fieldNames = new ArrayList<String>();
            String[] parsedHeaders = context.headers();
            if (parsedHeaders == null) {
                throw new IOException(String.format("The parsed headers from provided url: %s are null", url));
            }
            ArrayList<String> errors = new ArrayList<String>();
            for (int i = 0; i < parsedHeaders.length; ++i) {
                String name = parsedHeaders[i];
                if (name == null || name.isEmpty() || WHITESPACE.matcher(name).matches()) {
                    errors.add(String.format("found empty field name at index %d", i));
                } else if (fieldNames.contains(name)) {
                    errors.add(String.format("found duplicate field name at index %d", i));
                }
                fieldNames.add(name);
            }
            if (errors.isEmpty()) {
                return (MappedField[])fieldNames.stream().map(DefaultMappedField::new).toArray(MappedField[]::new);
            }
            String msg = url + " has invalid header: " + String.join((CharSequence)"; ", errors) + ".";
            throw new IOException(msg);
        }

        @NonNull
        public AbstractFileBasedConnector.RecordReader readNext(@NonNull SynchronousSink<com.datastax.oss.dsbulk.connectors.api.Record> sink) {
            try {
                Record row = this.parser.parseNextRecord();
                if (row != null) {
                    com.datastax.oss.dsbulk.connectors.api.Record record = this.parseNext(row);
                    LOGGER.trace("Emitting record {}", (Object)record);
                    sink.next((Object)record);
                } else {
                    LOGGER.debug("Done reading {}", (Object)this.url);
                    sink.complete();
                }
            }
            catch (Exception e) {
                IOException error = CSVConnector.this.asIOException(this.url, e, String.format("Error reading from %s at line %d", this.url, this.recordNumber));
                sink.error((Throwable)error);
            }
            return this;
        }

        @NonNull
        private com.datastax.oss.dsbulk.connectors.api.Record parseNext(Record row) {
            DefaultErrorRecord record;
            String source = CSVConnector.this.retainRecordSources ? this.context.currentParsedContent() : null;
            try {
                Object[] values = row.getValues();
                if (CSVConnector.this.header) {
                    record = DefaultRecord.mapped((Object)source, (URI)this.resource, (long)this.recordNumber++, (Field[])this.fieldNames, (Object[])values);
                    for (int i = 0; i < values.length; ++i) {
                        DefaultIndexedField field = new DefaultIndexedField(i);
                        Object value = values[i];
                        ((DefaultRecord)record).setFieldValue((Field)field, value);
                    }
                } else {
                    record = DefaultRecord.indexed((Object)source, (URI)this.resource, (long)this.recordNumber++, (Object[])values);
                }
            }
            catch (Exception e) {
                record = new DefaultErrorRecord((Object)source, this.resource, this.recordNumber, (Throwable)e);
            }
            return record;
        }

        public void close() {
            if (this.parser != null) {
                this.parser.stopParsing();
            }
        }
    }
}

