/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.connectors.api;

import com.datastax.oss.driver.shaded.guava.common.base.MoreObjects;
import com.datastax.oss.driver.shaded.guava.common.collect.Streams;
import com.datastax.oss.dsbulk.connectors.api.DefaultIndexedField;
import com.datastax.oss.dsbulk.connectors.api.Field;
import com.datastax.oss.dsbulk.connectors.api.Record;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;

public class DefaultRecord
extends LinkedHashMap<Field, Object>
implements Record {
    private final Object source;
    private final URI resource;
    private final long position;

    public static DefaultRecord indexed(@Nullable Object source, @NonNull URI resource, long position, Object ... values) {
        return new DefaultRecord(source, resource, position, values);
    }

    public static DefaultRecord mapped(@Nullable Object source, @NonNull URI resource, long position, Field[] keys, Object ... values) {
        return new DefaultRecord(source, resource, position, keys, values);
    }

    public static DefaultRecord mapped(@Nullable Object source, @NonNull URI resource, long position, Map<? extends Field, ?> values) {
        return new DefaultRecord(source, resource, position, values);
    }

    public DefaultRecord(@Nullable Object source, @NonNull URI resource, long position) {
        this.source = source;
        this.resource = resource;
        this.position = position;
    }

    private DefaultRecord(Object source, URI resource, long position, Object ... values) {
        this.source = source;
        this.resource = resource;
        this.position = position;
        Streams.forEachPair(IntStream.range(0, values.length).boxed().map(DefaultIndexedField::new), Arrays.stream(values), this::put);
    }

    private DefaultRecord(Object source, URI resource, long position, Field[] keys, Object ... values) {
        this.resource = resource;
        this.position = position;
        if (keys.length != values.length) {
            throw new IllegalArgumentException(String.format("Expecting record to contain %d fields but found %d.", keys.length, values.length));
        }
        this.source = source;
        Streams.forEachPair(Arrays.stream(keys), Arrays.stream(values), this::put);
    }

    private DefaultRecord(Object source, URI resource, long position, Map<? extends Field, ?> values) {
        this.resource = resource;
        this.position = position;
        this.source = source;
        this.putAll(values);
    }

    @Override
    @NonNull
    public Object getSource() {
        return this.source;
    }

    @Override
    @NonNull
    public URI getResource() {
        return this.resource;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    @NonNull
    public Set<Field> fields() {
        return this.keySet();
    }

    @Override
    @NonNull
    public Collection<Object> values() {
        return super.values();
    }

    @Override
    public Object getFieldValue(@NonNull Field field) {
        return this.get(field);
    }

    public void setFieldValue(@NonNull Field field, Object value) {
        this.put(field, value);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", this.source).add("resource", (Object)this.resource).add("position", this.position).add("entries", this.entrySet()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Record that = (Record)o;
        return this.getPosition() == that.getPosition() && Objects.equals(this.getSource(), that.getSource()) && Objects.equals(that.getResource(), this.getResource());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.source, this.resource, this.position);
    }
}

