/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.connectors.api;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.dsbulk.connectors.api.IndexedField;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class DefaultIndexedField
implements IndexedField {
    private final int index;

    public DefaultIndexedField(int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        this.index = index;
    }

    @Override
    public int getFieldIndex() {
        return this.index;
    }

    @Override
    @NonNull
    public String getFieldDescription() {
        return Integer.toString(this.index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexedField)) {
            return false;
        }
        IndexedField that = (IndexedField)o;
        return this.index == that.getFieldIndex();
    }

    public int hashCode() {
        return Objects.hash(this.index);
    }

    public String toString() {
        return this.getFieldDescription();
    }
}

