/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.connectors.api;

import com.datastax.oss.dsbulk.connectors.api.ConnectorFeature;
import com.datastax.oss.dsbulk.connectors.api.Record;
import com.datastax.oss.dsbulk.connectors.api.RecordMetadata;
import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public interface Connector
extends AutoCloseable {
    @NonNull
    public Publisher<Publisher<Record>> read();

    @NonNull
    public Function<Publisher<Record>, Publisher<Record>> write();

    default public void configure(@NonNull Config settings, boolean read, boolean retainRecordSources) throws IllegalArgumentException {
    }

    default public void init() throws Exception {
    }

    @Override
    default public void close() throws Exception {
    }

    default public boolean supports(@NonNull ConnectorFeature feature) {
        return false;
    }

    @NonNull
    public RecordMetadata getRecordMetadata();

    public int readConcurrency();

    public int writeConcurrency();
}

