/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.config.shortcuts;

import com.datastax.oss.driver.shaded.guava.common.collect.BiMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableBiMap;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortcutsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShortcutsFactory.class);

    @NonNull
    public static BiMap<String, String> createShortcutsMap() {
        return ShortcutsFactory.createShortcutsMap(ConfigUtils.standaloneDSBulkReference(), null);
    }

    @NonNull
    public static BiMap<String, String> createShortcutsMap(@NonNull Config referenceConfig, @Nullable String connectorName) {
        HashMap<String, String> shortcutsMap = new HashMap<String, String>();
        ShortcutsFactory.addGlobalShortcuts(referenceConfig, shortcutsMap);
        if (connectorName != null) {
            ShortcutsFactory.addConnectorShortcuts(referenceConfig, connectorName, shortcutsMap);
        }
        return ImmutableBiMap.copyOf(shortcutsMap);
    }

    private static void addGlobalShortcuts(@NonNull Config referenceConfig, @NonNull Map<String, String> shortcutsMap) {
        ConfigObject globalShortcutsConfig = referenceConfig.getObject("dsbulk.metaSettings.shortcuts");
        for (Map.Entry shortcutEntry : globalShortcutsConfig.entrySet()) {
            String shortcut = (String)shortcutEntry.getKey();
            String longOption = ((ConfigValue)shortcutEntry.getValue()).unwrapped().toString();
            shortcutsMap.put(shortcut, longOption);
        }
    }

    private static void addConnectorShortcuts(@NonNull Config referenceConfig, @NonNull String connectorName, @NonNull Map<String, String> shortcutsMap) {
        String connectorShortcutsPath = String.format("dsbulk.connector.%s.metaSettings.shortcuts", connectorName);
        if (referenceConfig.hasPath(connectorShortcutsPath)) {
            ConfigObject connectorShortcutsConfig = referenceConfig.getObject(connectorShortcutsPath);
            for (Map.Entry shortcutEntry : connectorShortcutsConfig.entrySet()) {
                String target;
                String shortcut = (String)shortcutEntry.getKey();
                if (shortcutsMap.putIfAbsent(shortcut, target = "dsbulk.connector." + connectorName + '.' + ((ConfigValue)shortcutEntry.getValue()).unwrapped()) == null) continue;
                LOGGER.warn(String.format("Shortcut %s => %s in %s connector shortcuts overlaps with global shortcuts and will be ignored", shortcut, target, connectorName));
            }
        }
    }
}

