/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.config.model;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SettingsComparator
implements Comparator<String> {
    private final Map<String, Integer> prioritizedValues = new HashMap<String, Integer>();

    SettingsComparator(String ... highPriorityValues) {
        this(Arrays.asList(highPriorityValues));
    }

    SettingsComparator(List<String> highPriorityValues) {
        int counter = 0;
        for (String s : highPriorityValues) {
            this.prioritizedValues.put(s, counter++);
        }
    }

    @Override
    public int compare(String left, String right) {
        Integer leftInd = Integer.MAX_VALUE;
        Integer rightInd = Integer.MAX_VALUE;
        for (String value : this.prioritizedValues.keySet()) {
            String valueWithDot = value + ".";
            if (left.startsWith(valueWithDot) || left.equals(value)) {
                leftInd = this.prioritizedValues.get(value);
            }
            if (!right.startsWith(valueWithDot) && !right.equals(value)) continue;
            rightInd = this.prioritizedValues.get(value);
        }
        int indCompare = leftInd.compareTo(rightInd);
        return indCompare != 0 ? indCompare : left.compareTo(right);
    }
}

