/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.api.writetime;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import java.time.Instant;
import java.util.concurrent.TimeUnit;

public class WriteTimeCodec<T>
extends ConvertingCodec<T, Long> {
    private final ConvertingCodec<T, Instant> innerCodec;

    public WriteTimeCodec(ConvertingCodec<T, Instant> innerCodec) {
        super(TypeCodecs.BIGINT, innerCodec.getJavaType());
        this.innerCodec = innerCodec;
    }

    @Override
    public Long externalToInternal(T value) {
        if (value == null) {
            return null;
        }
        Instant i = this.innerCodec.externalToInternal(value);
        if (i == null) {
            return null;
        }
        return CodecUtils.instantToNumber(i, TimeUnit.MICROSECONDS, Instant.EPOCH);
    }

    @Override
    public T internalToExternal(Long value) {
        if (value == null) {
            return null;
        }
        Instant i = CodecUtils.numberToInstant(value, TimeUnit.MICROSECONDS, Instant.EPOCH);
        return this.innerCodec.internalToExternal(i);
    }
}

