/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.api.util;

import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public enum OverflowStrategy {
    REJECT{

        @Override
        public Number apply(Number value, ArithmeticException e, Class<? extends Number> targetClass, RoundingMode roundingMode) {
            throw e;
        }
    }
    ,
    TRUNCATE{

        @Override
        public Number apply(Number value, ArithmeticException e, Class<? extends Number> targetClass, RoundingMode roundingMode) {
            if (targetClass.equals(Byte.class)) {
                if (value.longValue() > 127L) {
                    return (byte)127;
                }
                if (value.longValue() < -128L) {
                    return (byte)-128;
                }
                if (value.doubleValue() % 1.0 != 0.0) {
                    value = CodecUtils.toBigDecimal(value).setScale(0, roundingMode);
                }
                return value.byteValue();
            }
            if (targetClass.equals(Short.class)) {
                if (value.longValue() > 32767L) {
                    return (short)Short.MAX_VALUE;
                }
                if (value.longValue() < -32768L) {
                    return (short)Short.MIN_VALUE;
                }
                if (value.doubleValue() % 1.0 != 0.0) {
                    value = CodecUtils.toBigDecimal(value).setScale(0, roundingMode);
                }
                return value.shortValue();
            }
            if (targetClass.equals(Integer.class)) {
                if (value.longValue() > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                if (value.longValue() < Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                if (value.doubleValue() % 1.0 != 0.0) {
                    value = CodecUtils.toBigDecimal(value).setScale(0, roundingMode);
                }
                return value.intValue();
            }
            if (targetClass.equals(Long.class)) {
                BigDecimal d = CodecUtils.toBigDecimal(value);
                if (d.compareTo(LONG_MAX_VALUE) > 0) {
                    return Long.MAX_VALUE;
                }
                if (d.compareTo(LONG_MIN_VALUE) < 0) {
                    return Long.MIN_VALUE;
                }
                if (value.doubleValue() % 1.0 != 0.0) {
                    value = d.setScale(0, roundingMode);
                }
                return value.longValue();
            }
            if (targetClass.equals(BigInteger.class)) {
                if (value.doubleValue() % 1.0 != 0.0) {
                    value = CodecUtils.toBigDecimal(value).setScale(0, roundingMode);
                }
                return CodecUtils.toBigDecimal(value).toBigInteger();
            }
            if (targetClass.equals(Float.class)) {
                if (value.doubleValue() > 3.4028234663852886E38) {
                    return Float.valueOf(Float.MAX_VALUE);
                }
                if (value.doubleValue() < (double)1.4E-45f) {
                    return Float.valueOf(Float.MIN_VALUE);
                }
                return Float.valueOf(value.floatValue());
            }
            if (targetClass.equals(Double.class)) {
                BigDecimal d = CodecUtils.toBigDecimal(value);
                if (d.compareTo(DOUBLE_MAX_VALUE) > 0) {
                    return Double.MAX_VALUE;
                }
                if (d.compareTo(DOUBLE_MIN_VALUE) < 0) {
                    return Double.MIN_VALUE;
                }
                return value.doubleValue();
            }
            if (targetClass.equals(BigDecimal.class)) {
                return value;
            }
            throw e;
        }
    };

    private static final BigDecimal LONG_MIN_VALUE;
    private static final BigDecimal LONG_MAX_VALUE;
    private static final BigDecimal DOUBLE_MIN_VALUE;
    private static final BigDecimal DOUBLE_MAX_VALUE;

    public abstract Number apply(Number var1, ArithmeticException var2, Class<? extends Number> var3, RoundingMode var4);

    static {
        LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
        LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);
        DOUBLE_MIN_VALUE = BigDecimal.valueOf(Double.MIN_VALUE);
        DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
    }
}

