/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.api.util;

import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import com.datastax.dse.driver.api.core.data.time.DateRange;
import com.datastax.oss.driver.internal.core.util.Strings;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.format.binary.Base64BinaryFormat;
import com.datastax.oss.dsbulk.codecs.api.format.binary.HexBinaryFormat;
import com.datastax.oss.dsbulk.codecs.api.format.number.ExactNumberFormat;
import com.datastax.oss.dsbulk.codecs.api.format.number.ToStringNumberFormat;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.CqlTemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.NumericTemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.SimpleTemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.TemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.ZonedTemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.util.OverflowStrategy;
import com.datastax.oss.dsbulk.codecs.api.util.TimeUUIDGenerator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.netty.util.concurrent.FastThreadLocal;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class CodecUtils {
    private static final String CQL_TIMESTAMP = "CQL_TIMESTAMP";
    private static final String UNITS_SINCE_EPOCH = "UNITS_SINCE_EPOCH";

    public static Number parseNumber(String s, @NonNull NumberFormat numberFormat, @NonNull TemporalFormat temporalFormat, @NonNull ZoneId timeZone, @NonNull TimeUnit timeUnit, @NonNull ZonedDateTime epoch, @NonNull Map<String, Boolean> booleanStrings, @NonNull List<? extends Number> booleanNumbers) {
        Number number;
        block11: {
            Objects.requireNonNull(numberFormat);
            Objects.requireNonNull(temporalFormat);
            Objects.requireNonNull(timeZone);
            Objects.requireNonNull(timeUnit);
            Objects.requireNonNull(epoch);
            Objects.requireNonNull(booleanStrings);
            Objects.requireNonNull(booleanNumbers);
            if (s == null || s.isEmpty()) {
                return null;
            }
            try {
                number = CodecUtils.parseNumber(s, numberFormat);
            }
            catch (ParseException e1) {
                try {
                    number = new BigDecimal(s);
                }
                catch (NumberFormatException e2) {
                    e2.addSuppressed(e1);
                    try {
                        number = Double.valueOf(s);
                    }
                    catch (NumberFormatException e3) {
                        e3.addSuppressed(e2);
                        try {
                            TemporalAccessor temporal = temporalFormat.parse(s);
                            assert (temporal != null);
                            Instant instant = CodecUtils.toInstant(temporal, timeZone, epoch.toLocalDate());
                            number = CodecUtils.instantToNumber(instant, timeUnit, epoch.toInstant());
                        }
                        catch (DateTimeException e4) {
                            Boolean b = booleanStrings.get(s.toLowerCase());
                            if (b != null) {
                                number = booleanNumbers.get(b != false ? 0 : 1);
                                break block11;
                            }
                            e4.addSuppressed(e3);
                            IllegalArgumentException e5 = new IllegalArgumentException(String.format("Could not parse '%s'; accepted formats are: a valid number (e.g. '%s'), a valid Java numeric format (e.g. '-123.45e6'), a valid date-time pattern (e.g. '%s'), or a valid boolean word", s, CodecUtils.formatNumber(1234.56, numberFormat), temporalFormat.format(Instant.now())));
                            e5.addSuppressed(e4);
                            throw e5;
                        }
                    }
                }
            }
        }
        return number;
    }

    public static <N extends Number> N narrowNumber(Number value, @NonNull Class<? extends N> targetClass, @NonNull OverflowStrategy overflowStrategy, @NonNull RoundingMode roundingMode) {
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(overflowStrategy);
        Objects.requireNonNull(roundingMode);
        if (value == null) {
            return null;
        }
        try {
            return CodecUtils.convertNumber(value, targetClass);
        }
        catch (ArithmeticException e1) {
            Number truncated = overflowStrategy.apply(value, e1, targetClass, roundingMode);
            return (N)truncated;
        }
    }

    public static Instant numberToInstant(Number n, @NonNull TimeUnit timeUnit, @NonNull Instant epoch) {
        if (n == null) {
            return null;
        }
        Objects.requireNonNull(timeUnit);
        Objects.requireNonNull(epoch);
        Long l = CodecUtils.toLongValueExact(n);
        switch (timeUnit) {
            case NANOSECONDS: {
                return epoch.plusNanos(l);
            }
            case MICROSECONDS: {
                return epoch.plus((long)l, ChronoUnit.MICROS);
            }
            case MILLISECONDS: {
                return epoch.plusMillis(l);
            }
            case SECONDS: {
                return epoch.plusSeconds(l);
            }
        }
        return epoch.plusSeconds(timeUnit.toSeconds(l));
    }

    public static long instantToNumber(@NonNull Instant instant, @NonNull TimeUnit timeUnit, @NonNull Instant epoch) {
        Objects.requireNonNull(instant);
        Objects.requireNonNull(timeUnit);
        Objects.requireNonNull(epoch);
        long t1 = timeUnit.convert(instant.getEpochSecond(), TimeUnit.SECONDS) + timeUnit.convert(instant.getNano(), TimeUnit.NANOSECONDS);
        long t0 = timeUnit.convert(epoch.getEpochSecond(), TimeUnit.SECONDS) + timeUnit.convert(epoch.getNano(), TimeUnit.NANOSECONDS);
        return t1 - t0;
    }

    public static Number parseNumber(String s, @NonNull NumberFormat format) throws ParseException {
        Objects.requireNonNull(format);
        if (s == null || s.isEmpty()) {
            return null;
        }
        ParsePosition pos = new ParsePosition(0);
        Number number = format.parse(s.trim(), pos);
        if (number == null) {
            throw new ParseException("Invalid number format: " + s, pos.getErrorIndex());
        }
        if (pos.getIndex() != s.length()) {
            throw new ParseException("Invalid number format: " + s, pos.getIndex());
        }
        return number;
    }

    public static String formatNumber(Number value, @NonNull NumberFormat format) throws NumberFormatException {
        Objects.requireNonNull(format);
        if (value == null) {
            return null;
        }
        return format.format(value);
    }

    public static <N extends Number> N convertNumber(Number value, @NonNull Class<? extends N> targetClass) throws ArithmeticException {
        Objects.requireNonNull(targetClass);
        if (value == null) {
            return null;
        }
        if (targetClass.equals(Byte.class)) {
            return (N)CodecUtils.toByteValueExact(value);
        }
        if (targetClass.equals(Short.class)) {
            return (N)CodecUtils.toShortValueExact(value);
        }
        if (targetClass.equals(Integer.class)) {
            return (N)CodecUtils.toIntValueExact(value);
        }
        if (targetClass.equals(Long.class)) {
            return (N)CodecUtils.toLongValueExact(value);
        }
        if (targetClass.equals(BigInteger.class)) {
            return (N)CodecUtils.toBigIntegerExact(value);
        }
        if (targetClass.equals(Float.class)) {
            return (N)CodecUtils.toFloatValueExact(value);
        }
        if (targetClass.equals(Double.class)) {
            return (N)CodecUtils.toDoubleValueExact(value);
        }
        if (targetClass.equals(BigDecimal.class)) {
            return (N)CodecUtils.toBigDecimal(value);
        }
        throw CodecUtils.conversionFailed(value, targetClass);
    }

    public static Byte toByteValueExact(@NonNull Number value) throws ArithmeticException {
        Objects.requireNonNull(value);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Short) {
            if (value.byteValue() != value.shortValue()) {
                throw CodecUtils.conversionFailed(value, Byte.class);
            }
            return value.byteValue();
        }
        if (value instanceof Integer) {
            if (value.byteValue() != value.intValue()) {
                throw CodecUtils.conversionFailed(value, Byte.class);
            }
            return value.byteValue();
        }
        if (value instanceof Long) {
            if ((long)value.byteValue() != value.longValue()) {
                throw CodecUtils.conversionFailed(value, Byte.class);
            }
            return value.byteValue();
        }
        try {
            if (value instanceof BigInteger) {
                return ((BigInteger)value).byteValueExact();
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).byteValueExact();
            }
            return new BigDecimal(value.toString()).byteValueExact();
        }
        catch (ArithmeticException e) {
            throw CodecUtils.conversionFailed(value, Byte.class, e);
        }
    }

    public static Short toShortValueExact(@NonNull Number value) throws ArithmeticException {
        Objects.requireNonNull(value);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return value.shortValue();
        }
        if (value instanceof Integer) {
            if (value.shortValue() != value.intValue()) {
                throw CodecUtils.conversionFailed(value, Short.class);
            }
            return value.shortValue();
        }
        if (value instanceof Long) {
            if ((long)value.shortValue() != value.longValue()) {
                throw CodecUtils.conversionFailed(value, Short.class);
            }
            return value.shortValue();
        }
        try {
            if (value instanceof BigInteger) {
                return ((BigInteger)value).shortValueExact();
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).shortValueExact();
            }
            return new BigDecimal(value.toString()).shortValueExact();
        }
        catch (ArithmeticException e) {
            throw CodecUtils.conversionFailed(value, Short.class, e);
        }
    }

    public static Integer toIntValueExact(@NonNull Number value) throws ArithmeticException {
        Objects.requireNonNull(value);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Byte || value instanceof Short) {
            return value.intValue();
        }
        if (value instanceof Long) {
            if ((long)value.intValue() != value.longValue()) {
                throw CodecUtils.conversionFailed(value, Integer.class);
            }
            return value.intValue();
        }
        try {
            if (value instanceof BigInteger) {
                return ((BigInteger)value).intValueExact();
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).intValueExact();
            }
            return new BigDecimal(value.toString()).intValueExact();
        }
        catch (ArithmeticException e) {
            throw CodecUtils.conversionFailed(value, Integer.class, e);
        }
    }

    public static Long toLongValueExact(@NonNull Number value) throws ArithmeticException {
        Objects.requireNonNull(value);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
            return value.longValue();
        }
        try {
            if (value instanceof BigInteger) {
                return ((BigInteger)value).longValueExact();
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).longValueExact();
            }
            return new BigDecimal(value.toString()).longValueExact();
        }
        catch (ArithmeticException e) {
            throw CodecUtils.conversionFailed(value, Long.class, e);
        }
    }

    public static BigInteger toBigIntegerExact(@NonNull Number value) throws ArithmeticException {
        Objects.requireNonNull(value);
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return BigInteger.valueOf(value.longValue());
        }
        try {
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigIntegerExact();
            }
            return new BigDecimal(value.toString()).toBigIntegerExact();
        }
        catch (ArithmeticException e) {
            throw CodecUtils.conversionFailed(value, BigInteger.class, e);
        }
    }

    public static Float toFloatValueExact(@NonNull Number value) throws ArithmeticException, NumberFormatException {
        Objects.requireNonNull(value);
        if (value instanceof Float) {
            return (Float)value;
        }
        if (Float.isNaN(value.floatValue())) {
            return Float.valueOf(Float.NaN);
        }
        if (Float.isInfinite(value.floatValue())) {
            if (value.doubleValue() == Double.NEGATIVE_INFINITY) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            if (value.doubleValue() == Double.POSITIVE_INFINITY) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            throw CodecUtils.conversionFailed(value, Float.class);
        }
        if (CodecUtils.toBigDecimal(value).compareTo(new BigDecimal(Float.toString(value.floatValue()))) != 0) {
            throw CodecUtils.conversionFailed(value, Float.class);
        }
        return Float.valueOf(value.floatValue());
    }

    public static Double toDoubleValueExact(@NonNull Number value) throws ArithmeticException, NumberFormatException {
        Objects.requireNonNull(value);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (Double.isNaN(value.doubleValue())) {
            return Double.NaN;
        }
        if (Double.isInfinite(value.doubleValue())) {
            if (value.floatValue() == Float.NEGATIVE_INFINITY) {
                return Double.NEGATIVE_INFINITY;
            }
            if (value.floatValue() == Float.POSITIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
            throw CodecUtils.conversionFailed(value, Double.class);
        }
        if (CodecUtils.toBigDecimal(value).compareTo(new BigDecimal(Double.toString(value.doubleValue()))) != 0) {
            throw CodecUtils.conversionFailed(value, Double.class);
        }
        return value.doubleValue();
    }

    public static BigDecimal toBigDecimal(@NonNull Number value) throws ArithmeticException {
        Objects.requireNonNull(value);
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return BigDecimal.valueOf(value.longValue());
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        try {
            return new BigDecimal(value.toString());
        }
        catch (NumberFormatException e) {
            throw CodecUtils.conversionFailed(value, BigDecimal.class, e);
        }
    }

    private static ArithmeticException conversionFailed(@NonNull Number value, @NonNull Class<? extends Number> targetClass, @NonNull Throwable cause) {
        return (ArithmeticException)CodecUtils.conversionFailed(value, targetClass).initCause(cause);
    }

    private static ArithmeticException conversionFailed(@NonNull Number value, @NonNull Class<? extends Number> targetClass) {
        return new ArithmeticException(String.format("Cannot convert %s from %s to %s", value, value.getClass().getSimpleName(), targetClass.getSimpleName()));
    }

    public static <T extends TemporalAccessor> T convertTemporal(TemporalAccessor value, @NonNull Class<? extends T> targetClass, @NonNull ZoneId timeZone, @NonNull LocalDate epoch) throws DateTimeException {
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(timeZone);
        Objects.requireNonNull(epoch);
        if (value == null) {
            return null;
        }
        if (targetClass.equals(LocalDate.class)) {
            return (T)CodecUtils.toLocalDate(value, timeZone);
        }
        if (targetClass.equals(LocalTime.class)) {
            return (T)CodecUtils.toLocalTime(value, timeZone);
        }
        if (targetClass.equals(LocalDateTime.class)) {
            return (T)CodecUtils.toLocalDateTime(value, timeZone, epoch);
        }
        if (targetClass.equals(Instant.class)) {
            return (T)CodecUtils.toInstant(value, timeZone, epoch);
        }
        if (targetClass.equals(ZonedDateTime.class)) {
            return (T)CodecUtils.toZonedDateTime(value, timeZone, epoch);
        }
        throw new DateTimeException(String.format("Cannot convert %s of type %s to %s", value, value.getClass(), targetClass));
    }

    public static ZonedDateTime toZonedDateTime(@NonNull TemporalAccessor value, @NonNull ZoneId timeZone, @NonNull LocalDate epoch) throws DateTimeException {
        Objects.requireNonNull(value);
        Objects.requireNonNull(timeZone);
        Objects.requireNonNull(epoch);
        if (value instanceof LocalDate) {
            return ((LocalDate)value).atStartOfDay(timeZone);
        }
        if (value instanceof LocalTime) {
            return ((LocalTime)value).atDate(epoch).atZone(timeZone);
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).atZone(timeZone);
        }
        if (value instanceof Instant) {
            return ((Instant)value).atZone(timeZone);
        }
        if (value instanceof ZonedDateTime) {
            return (ZonedDateTime)value;
        }
        if (value.query(TemporalQueries.zone()) != null) {
            return ZonedDateTime.from(value);
        }
        return Instant.from(value).atZone(timeZone);
    }

    public static Instant toInstant(@NonNull TemporalAccessor value, @NonNull ZoneId timeZone, @NonNull LocalDate epoch) throws DateTimeException {
        Objects.requireNonNull(value);
        Objects.requireNonNull(timeZone);
        Objects.requireNonNull(epoch);
        if (value instanceof LocalDate) {
            return ((LocalDate)value).atStartOfDay(timeZone).toInstant();
        }
        if (value instanceof LocalTime) {
            return ((LocalTime)value).atDate(epoch).atZone(timeZone).toInstant();
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).atZone(timeZone).toInstant();
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toInstant();
        }
        return Instant.from(value);
    }

    public static LocalDateTime toLocalDateTime(@NonNull TemporalAccessor value, @NonNull ZoneId timeZone, @NonNull LocalDate epoch) throws DateTimeException {
        Objects.requireNonNull(value);
        Objects.requireNonNull(timeZone);
        Objects.requireNonNull(epoch);
        if (value instanceof LocalDate) {
            return ((LocalDate)value).atStartOfDay();
        }
        if (value instanceof LocalTime) {
            return ((LocalTime)value).atDate(epoch);
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof Instant) {
            return ((Instant)value).atZone(timeZone).toLocalDateTime();
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDateTime();
        }
        return LocalDateTime.from(value);
    }

    public static LocalDate toLocalDate(@NonNull TemporalAccessor value, @NonNull ZoneId timeZone) throws DateTimeException {
        Objects.requireNonNull(value);
        Objects.requireNonNull(timeZone);
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        if (value instanceof Instant) {
            return ((Instant)value).atZone(timeZone).toLocalDate();
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDate();
        }
        return LocalDate.from(value);
    }

    public static LocalTime toLocalTime(@NonNull TemporalAccessor value, @NonNull ZoneId timeZone) throws DateTimeException {
        Objects.requireNonNull(value);
        Objects.requireNonNull(timeZone);
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalTime();
        }
        if (value instanceof Instant) {
            return ((Instant)value).atZone(timeZone).toLocalTime();
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalTime();
        }
        return LocalTime.from(value);
    }

    public static UUID parseUUID(String s, @NonNull ConvertingCodec<String, Instant> instantCodec, @NonNull TimeUUIDGenerator generator) {
        Objects.requireNonNull(instantCodec);
        Objects.requireNonNull(generator);
        if (s == null || s.isEmpty()) {
            return null;
        }
        try {
            return UUID.fromString(s);
        }
        catch (IllegalArgumentException e1) {
            Instant instant;
            try {
                instant = instantCodec.externalToInternal(s);
            }
            catch (Exception e2) {
                e2.addSuppressed(e1);
                throw new IllegalArgumentException("Invalid UUID string: " + s, e2);
            }
            return generator.generate(instant);
        }
    }

    @Nullable
    public static ByteBuffer parseByteBuffer(@Nullable String s) {
        try {
            return HexBinaryFormat.INSTANCE.parse(s);
        }
        catch (Exception e) {
            try {
                return Base64BinaryFormat.INSTANCE.parse(s);
            }
            catch (Exception e1) {
                e1.addSuppressed(e);
                throw new IllegalArgumentException("Invalid binary string: " + s, e1);
            }
        }
    }

    public static Point parsePoint(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        try {
            return Point.fromWellKnownText((String)Strings.unquote((String)s));
        }
        catch (Exception e) {
            try {
                return Point.fromGeoJson((String)s);
            }
            catch (Exception e1) {
                e1.addSuppressed(e);
                try {
                    ByteBuffer wkb = Objects.requireNonNull(CodecUtils.parseByteBuffer(s));
                    return Point.fromWellKnownBinary((ByteBuffer)wkb);
                }
                catch (Exception e2) {
                    e2.addSuppressed(e1);
                    throw new IllegalArgumentException("Invalid point literal: " + s, e2);
                }
            }
        }
    }

    public static LineString parseLineString(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        try {
            return LineString.fromWellKnownText((String)Strings.unquote((String)s));
        }
        catch (Exception e) {
            try {
                return LineString.fromGeoJson((String)s);
            }
            catch (Exception e1) {
                e1.addSuppressed(e);
                try {
                    ByteBuffer wkb = Objects.requireNonNull(CodecUtils.parseByteBuffer(s));
                    return LineString.fromWellKnownBinary((ByteBuffer)wkb);
                }
                catch (Exception e2) {
                    e2.addSuppressed(e1);
                    throw new IllegalArgumentException("Invalid line string literal: " + s, e2);
                }
            }
        }
    }

    public static Polygon parsePolygon(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        try {
            return Polygon.fromWellKnownText((String)Strings.unquote((String)s));
        }
        catch (Exception e) {
            try {
                return Polygon.fromGeoJson((String)s);
            }
            catch (Exception e1) {
                e1.addSuppressed(e);
                try {
                    ByteBuffer wkb = Objects.requireNonNull(CodecUtils.parseByteBuffer(s));
                    return Polygon.fromWellKnownBinary((ByteBuffer)wkb);
                }
                catch (Exception e2) {
                    e2.addSuppressed(e1);
                    throw new IllegalArgumentException("Invalid polygon literal: " + s, e2);
                }
            }
        }
    }

    public static DateRange parseDateRange(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        try {
            return DateRange.parse((String)s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid date range literal: " + s, e);
        }
    }

    public static FastThreadLocal<NumberFormat> getNumberFormatThreadLocal(final String pattern, final Locale locale, final RoundingMode roundingMode, final boolean formatNumbers) {
        return new FastThreadLocal<NumberFormat>(){

            protected NumberFormat initialValue() {
                return CodecUtils.getNumberFormat(pattern, locale, roundingMode, formatNumbers);
            }
        };
    }

    public static NumberFormat getNumberFormat(String pattern, Locale locale, RoundingMode roundingMode, boolean formatNumbers) {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        symbols.setNaN("NaN");
        symbols.setInfinity("Infinity");
        DecimalFormat format = new DecimalFormat(pattern, symbols);
        format.setParseBigDecimal(true);
        format.setRoundingMode(roundingMode);
        if (roundingMode == RoundingMode.UNNECESSARY) {
            format.setMaximumFractionDigits(Integer.MAX_VALUE);
        }
        if (!formatNumbers) {
            return new ToStringNumberFormat(format);
        }
        return new ExactNumberFormat(format);
    }

    public static TemporalFormat getTemporalFormat(@NonNull String pattern, @NonNull ZoneId timeZone, @NonNull Locale locale, @NonNull TimeUnit timeUnit, @NonNull ZonedDateTime epoch, @NonNull FastThreadLocal<NumberFormat> numberFormat, boolean useZonedParser) {
        if (pattern.equals(CQL_TIMESTAMP)) {
            return new CqlTemporalFormat(timeZone);
        }
        if (pattern.equals(UNITS_SINCE_EPOCH)) {
            return new NumericTemporalFormat(numberFormat, timeZone, timeUnit, epoch);
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().parseStrict().parseCaseInsensitive();
        try {
            Field field = DateTimeFormatter.class.getDeclaredField(pattern);
            DateTimeFormatter formatter = (DateTimeFormatter)field.get(null);
            builder = builder.append(formatter);
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            builder = builder.appendPattern(pattern);
        }
        DateTimeFormatter format = builder.toFormatter(locale).withResolverStyle(ResolverStyle.SMART).withChronology(IsoChronology.INSTANCE);
        if (useZonedParser) {
            return new ZonedTemporalFormat(format, timeZone);
        }
        return new SimpleTemporalFormat(format);
    }

    public static Locale parseLocale(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, "_");
        String language = tokenizer.nextToken();
        if (tokenizer.hasMoreTokens()) {
            String country = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                String variant = tokenizer.nextToken();
                return new Locale(language, country, variant);
            }
            return new Locale(language, country);
        }
        return new Locale(language);
    }
}

