/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.api.format.temporal;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.SimpleTemporalFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;

public class ZonedTemporalFormat
extends SimpleTemporalFormat {
    private final ZoneId timeZone;

    public ZonedTemporalFormat(DateTimeFormatter parserAndFormatter, ZoneId timeZone) {
        this(parserAndFormatter, parserAndFormatter, timeZone);
    }

    public ZonedTemporalFormat(DateTimeFormatter parser, DateTimeFormatter formatter, ZoneId timeZone) {
        super(parser, formatter.withZone(timeZone));
        Preconditions.checkState((parser.getZone() == null ? 1 : 0) != 0, (Object)"parser should not have an override zone");
        this.timeZone = timeZone;
    }

    @Override
    public TemporalAccessor parse(String text) {
        TemporalAccessor temporal = super.parse(text);
        if (temporal == null) {
            return null;
        }
        if (!temporal.isSupported(ChronoField.INSTANT_SECONDS)) {
            return ZonedDateTime.of(temporal.query(TemporalQueries.localDate()), temporal.query(TemporalQueries.localTime()), this.timeZone);
        }
        return temporal;
    }
}

