/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.api.format.number;

import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class ExactNumberFormat
extends NumberFormat {
    private final NumberFormat delegate;

    public ExactNumberFormat(NumberFormat delegate) {
        this.delegate = delegate;
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return this.delegate.parse(source, parsePosition);
    }

    @Override
    public StringBuffer format(Object number, StringBuffer result, FieldPosition fieldPosition) {
        if (number instanceof Float || number instanceof Double) {
            try {
                number = CodecUtils.toBigDecimal((Number)number);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return this.delegate.format(number, result, fieldPosition);
    }

    @Override
    public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        return this.delegate.format(number, result, fieldPosition);
    }

    @Override
    public StringBuffer format(long number, StringBuffer result, FieldPosition fieldPosition) {
        return this.delegate.format(number, result, fieldPosition);
    }
}

