/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.api.format.binary;

import com.datastax.oss.driver.api.core.data.ByteUtils;
import com.datastax.oss.dsbulk.codecs.api.format.binary.BinaryFormat;
import java.nio.ByteBuffer;
import java.util.Base64;

public class Base64BinaryFormat
implements BinaryFormat {
    public static final Base64BinaryFormat INSTANCE = new Base64BinaryFormat();

    private Base64BinaryFormat() {
    }

    @Override
    public ByteBuffer parse(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return ByteBuffer.allocate(0);
        }
        return ByteBuffer.wrap(Base64.getDecoder().decode(s));
    }

    @Override
    public String format(ByteBuffer bb) {
        if (bb == null) {
            return null;
        }
        if (bb.remaining() == 0) {
            return "";
        }
        return Base64.getEncoder().encodeToString(ByteUtils.getArray((ByteBuffer)bb));
    }
}

