/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.api;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.registry.MutableCodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.registry.DefaultCodecRegistry;
import com.datastax.oss.dsbulk.codecs.api.CommonConversionContext;
import com.datastax.oss.dsbulk.codecs.api.ConversionContext;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecProvider;
import com.datastax.oss.dsbulk.codecs.api.IdempotentConvertingCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConvertingCodecFactory {
    private final List<ConvertingCodecProvider> providers = new CopyOnWriteArrayList<ConvertingCodecProvider>();
    @NonNull
    private final MutableCodecRegistry codecRegistry;
    private final ConversionContext context;

    public ConvertingCodecFactory() {
        this((MutableCodecRegistry)new DefaultCodecRegistry("default"), new CommonConversionContext());
    }

    public ConvertingCodecFactory(@NonNull ConversionContext context) {
        this((MutableCodecRegistry)new DefaultCodecRegistry("default"), context);
    }

    public ConvertingCodecFactory(@NonNull MutableCodecRegistry codecRegistry, @NonNull ConversionContext context) {
        this.codecRegistry = codecRegistry;
        this.context = context;
        ServiceLoader<ConvertingCodecProvider> loader = ServiceLoader.load(ConvertingCodecProvider.class);
        for (ConvertingCodecProvider provider : loader) {
            this.providers.add(provider);
        }
    }

    @NonNull
    public MutableCodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @NonNull
    public ConversionContext getContext() {
        return this.context;
    }

    @NonNull
    public <EXTERNAL, INTERNAL> ConvertingCodec<EXTERNAL, INTERNAL> createConvertingCodec(@NonNull DataType cqlType, @NonNull GenericType<EXTERNAL> externalJavaType, boolean rootCodec) {
        for (ConvertingCodecProvider provider : this.providers) {
            Optional<ConvertingCodec<?, ?>> maybeCodec = provider.maybeProvide(cqlType, externalJavaType, this, rootCodec);
            if (!maybeCodec.isPresent()) continue;
            ConvertingCodec<?, ?> codec = maybeCodec.get();
            return codec;
        }
        IdempotentConvertingCodec codec = new IdempotentConvertingCodec(this.codecRegistry.codecFor(cqlType, externalJavaType));
        return codec;
    }
}

