/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.batcher.api;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.DefaultBatchType;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.dsbulk.batcher.api.BatchMode;
import com.datastax.oss.dsbulk.batcher.api.StatementBatcher;
import com.datastax.oss.dsbulk.sampler.DataSizes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class DefaultStatementBatcher
implements StatementBatcher {
    protected final CqlSession session;
    protected final BatchMode batchMode;
    protected final BatchType batchType;
    protected final ProtocolVersion protocolVersion;
    protected final CodecRegistry codecRegistry;
    protected final int maxBatchStatements;
    protected final long maxSizeInBytes;

    protected DefaultStatementBatcher() {
        this.session = null;
        this.batchMode = BatchMode.PARTITION_KEY;
        this.batchType = DefaultBatchType.UNLOGGED;
        this.protocolVersion = ProtocolVersion.DEFAULT;
        this.codecRegistry = CodecRegistry.DEFAULT;
        this.maxBatchStatements = 100;
        this.maxSizeInBytes = -1L;
    }

    public DefaultStatementBatcher(int maxBatchStatements) {
        this.session = null;
        this.batchMode = BatchMode.PARTITION_KEY;
        this.batchType = DefaultBatchType.UNLOGGED;
        this.protocolVersion = ProtocolVersion.DEFAULT;
        this.codecRegistry = CodecRegistry.DEFAULT;
        this.maxBatchStatements = maxBatchStatements;
        this.maxSizeInBytes = -1L;
    }

    public DefaultStatementBatcher(long maxSizeInBytes) {
        this.session = null;
        this.batchMode = BatchMode.PARTITION_KEY;
        this.batchType = DefaultBatchType.UNLOGGED;
        this.protocolVersion = ProtocolVersion.DEFAULT;
        this.codecRegistry = CodecRegistry.DEFAULT;
        this.maxBatchStatements = 100;
        this.maxSizeInBytes = maxSizeInBytes;
    }

    public DefaultStatementBatcher(int maxBatchStatements, long maxSizeInBytes) {
        this.session = null;
        this.batchMode = BatchMode.PARTITION_KEY;
        this.batchType = DefaultBatchType.UNLOGGED;
        this.protocolVersion = ProtocolVersion.DEFAULT;
        this.codecRegistry = CodecRegistry.DEFAULT;
        this.maxBatchStatements = maxBatchStatements;
        this.maxSizeInBytes = maxSizeInBytes;
    }

    public DefaultStatementBatcher(@Nullable CqlSession session) {
        this(session, BatchMode.PARTITION_KEY);
    }

    public DefaultStatementBatcher(@Nullable CqlSession session, @NonNull BatchMode batchMode) {
        this(session, batchMode, (BatchType)DefaultBatchType.UNLOGGED, 100);
    }

    public DefaultStatementBatcher(@Nullable CqlSession session, @NonNull BatchMode batchMode, @NonNull BatchType batchType, int maxBatchStatements) {
        this(session, batchMode, batchType, maxBatchStatements, -1L);
    }

    public DefaultStatementBatcher(@Nullable CqlSession session, @NonNull BatchMode batchMode, @NonNull BatchType batchType, int maxBatchStatements, long maxSizeInBytes) {
        this.session = Objects.requireNonNull(session);
        this.batchMode = Objects.requireNonNull(batchMode);
        this.batchType = Objects.requireNonNull(batchType);
        this.protocolVersion = session.getContext().getProtocolVersion();
        this.codecRegistry = session.getContext().getCodecRegistry();
        if (maxBatchStatements < 0 && maxSizeInBytes < 0L) {
            throw new IllegalArgumentException("At least one of maxBatchStatements or maxSizeInBytes must be positive");
        }
        this.maxBatchStatements = maxBatchStatements;
        this.maxSizeInBytes = maxSizeInBytes;
    }

    @Override
    @NonNull
    public List<Statement<?>> batchByGroupingKey(@NonNull Iterable<BatchableStatement<?>> statements) {
        return StreamSupport.stream(statements.spliterator(), false).collect(Collectors.groupingBy(this::groupingKey)).values().stream().flatMap(stmts -> this.maybeBatch((Collection<BatchableStatement<?>>)stmts).stream()).collect(Collectors.toList());
    }

    @Override
    @NonNull
    public List<Statement<?>> batchAll(@NonNull Collection<BatchableStatement<?>> statements) {
        return this.maybeBatch(statements);
    }

    @NonNull
    private List<Statement<?>> maybeBatch(@NonNull Collection<BatchableStatement<?>> stmts) {
        Objects.requireNonNull(stmts);
        Preconditions.checkArgument((!stmts.isEmpty() ? 1 : 0) != 0);
        if (stmts.size() == 1) {
            if (stmts instanceof List) {
                List list = (List)stmts;
                return Collections.singletonList((Statement)list.get(0));
            }
            return Collections.singletonList((Statement)stmts.iterator().next());
        }
        ImmutableList.Builder batches = ImmutableList.builder();
        ArrayList current = new ArrayList();
        AdaptiveSizingBatchPredicate shouldFlush = new AdaptiveSizingBatchPredicate();
        Iterator<BatchableStatement<?>> it = stmts.iterator();
        while (it.hasNext()) {
            BatchableStatement<?> stmt = it.next();
            current.add(stmt);
            if (!shouldFlush.test(stmt)) continue;
            this.flush(current, batches);
            if (!it.hasNext()) continue;
            current.clear();
        }
        if (current.size() > 0) {
            this.flush(current, batches);
        }
        return batches.build();
    }

    private void flush(List<BatchableStatement<?>> current, ImmutableList.Builder<Statement<?>> batches) {
        if (current.size() == 1) {
            batches.add((Object)((Statement)current.get(0)));
        } else {
            batches.add((Object)BatchStatement.newInstance((BatchType)this.batchType, current));
        }
    }

    @NonNull
    protected Object groupingKey(@NonNull Statement<?> statement) {
        Token routingToken = statement.getRoutingToken();
        ByteBuffer routingKey = statement.getRoutingKey();
        switch (this.batchMode) {
            case REPLICA_SET: {
                TokenMap tokenMap;
                CqlIdentifier keyspace = this.getKeyspace(statement);
                if (keyspace != null && (tokenMap = (TokenMap)this.session.getMetadata().getTokenMap().orElse(null)) != null) {
                    Set replicas = null;
                    if (routingKey != null) {
                        replicas = tokenMap.getReplicas(keyspace, routingKey);
                    } else if (routingToken != null) {
                        replicas = tokenMap.getReplicas(keyspace, routingToken);
                    }
                    if (replicas != null && !replicas.isEmpty()) {
                        return replicas.hashCode();
                    }
                }
            }
            case PARTITION_KEY: {
                if (routingToken != null) {
                    return routingToken;
                }
                if (routingKey == null || !routingKey.hasRemaining()) break;
                return routingKey;
            }
        }
        return statement;
    }

    @Nullable
    private CqlIdentifier getKeyspace(Statement<?> statement) {
        if (statement.getKeyspace() != null) {
            return statement.getKeyspace();
        }
        if (statement.getRoutingKeyspace() != null) {
            return statement.getRoutingKeyspace();
        }
        return this.session.getKeyspace().orElse(null);
    }

    protected class AdaptiveSizingBatchPredicate
    implements Predicate<BatchableStatement<?>> {
        private int statementsCounter = 0;
        private long bytesInCurrentBatch = 0L;

        protected AdaptiveSizingBatchPredicate() {
        }

        @Override
        public boolean test(@NonNull BatchableStatement<?> statement) {
            boolean shouldFlush;
            boolean statementsOverflowBuffer = ++this.statementsCounter >= this.getMaxBatchStatements();
            boolean bytesOverflowBuffer = (this.bytesInCurrentBatch += this.calculateSize((Statement<?>)statement)) >= this.getMaxSizeInBytes();
            boolean bl = shouldFlush = statementsOverflowBuffer || bytesOverflowBuffer;
            if (shouldFlush) {
                this.statementsCounter = 0;
                this.bytesInCurrentBatch = 0L;
            }
            return shouldFlush;
        }

        long calculateSize(@NonNull Statement<?> statement) {
            return DataSizes.getDataSize(statement, (ProtocolVersion)DefaultStatementBatcher.this.protocolVersion, (CodecRegistry)DefaultStatementBatcher.this.codecRegistry);
        }

        int getMaxBatchStatements() {
            if (DefaultStatementBatcher.this.maxBatchStatements <= 0) {
                return Integer.MAX_VALUE;
            }
            return DefaultStatementBatcher.this.maxBatchStatements;
        }

        long getMaxSizeInBytes() {
            if (DefaultStatementBatcher.this.maxSizeInBytes <= 0L) {
                return Long.MAX_VALUE;
            }
            return DefaultStatementBatcher.this.maxSizeInBytes;
        }
    }
}

