/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.utils;

import com.dtsx.astra.sdk.exception.AuthenticationException;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientWrapper.class);
    private static final String REQUEST_WITH = "AstraJavaSDK " + HttpClientWrapper.class.getPackage().getImplementationVersion();
    private static final int DEFAULT_TIMEOUT_REQUEST = 20;
    private static final int DEFAULT_TIMEOUT_CONNECT = 20;
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final String HEADER_REQUESTED_WITH = "X-Requested-With";
    private static final String HEADER_CURRENT_ORG = "X-DataStax-Current-Org";
    private static final String HEADER_CURRENT_PULSAR_CLUSTER = "X-DataStax-Pulsar-Cluster";
    private static HttpClientWrapper _instance = null;
    protected CloseableHttpClient httpClient = null;
    protected static RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("strict").setExpectContinueEnabled(true).setConnectionRequestTimeout(Timeout.ofSeconds((long)20L)).setConnectTimeout(Timeout.ofSeconds((long)20L)).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).build();

    private HttpClientWrapper() {
    }

    public static synchronized HttpClientWrapper getInstance() {
        if (_instance == null) {
            _instance = new HttpClientWrapper();
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
            connManager.setValidateAfterInactivity(TimeValue.ofSeconds((long)10L));
            connManager.setMaxTotal(100);
            connManager.setDefaultMaxPerRoute(10);
            HttpClientWrapper._instance.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        }
        return _instance;
    }

    public ApiResponseHttp GET(String url, String token) {
        return this.executeHttp(Method.GET, url, token, null, CONTENT_TYPE_JSON, false);
    }

    public ApiResponseHttp GET_PULSAR(String url, String token, String pulsarCluster, String organizationId) {
        HttpUriRequestBase request = this.buildRequest(Method.GET, url, token, null, CONTENT_TYPE_JSON);
        this.updatePulsarHttpRequest(request, token, pulsarCluster, organizationId);
        return this.executeHttp(request, false);
    }

    public ApiResponseHttp POST_PULSAR(String url, String token, String body, String pulsarCluster, String organizationId) {
        HttpUriRequestBase request = this.buildRequest(Method.POST, url, token, body, CONTENT_TYPE_JSON);
        this.updatePulsarHttpRequest(request, token, pulsarCluster, organizationId);
        return this.executeHttp(request, false);
    }

    public ApiResponseHttp DELETE_PULSAR(String url, String token, String body, String pulsarCluster, String organizationId) {
        HttpUriRequestBase request = this.buildRequest(Method.DELETE, url, token, body, CONTENT_TYPE_JSON);
        this.updatePulsarHttpRequest(request, token, pulsarCluster, organizationId);
        return this.executeHttp(request, false);
    }

    private void updatePulsarHttpRequest(HttpUriRequestBase request, String pulsarToken, String pulsarCluster, String organizationId) {
        request.addHeader(HEADER_AUTHORIZATION, (Object)pulsarToken);
        request.addHeader(HEADER_CURRENT_ORG, (Object)organizationId);
        request.addHeader(HEADER_CURRENT_PULSAR_CLUSTER, (Object)pulsarCluster);
    }

    public ApiResponseHttp HEAD(String url, String token) {
        return this.executeHttp(Method.HEAD, url, token, null, CONTENT_TYPE_JSON, false);
    }

    public ApiResponseHttp POST(String url, String token) {
        return this.executeHttp(Method.POST, url, token, null, CONTENT_TYPE_JSON, true);
    }

    public ApiResponseHttp POST(String url, String token, String body) {
        return this.executeHttp(Method.POST, url, token, body, CONTENT_TYPE_JSON, true);
    }

    public void DELETE(String url, String token) {
        this.executeHttp(Method.DELETE, url, token, null, CONTENT_TYPE_JSON, true);
    }

    public void PUT(String url, String token, String body) {
        this.executeHttp(Method.PUT, url, token, body, CONTENT_TYPE_JSON, false);
    }

    public void PATCH(String url, String token, String body) {
        this.executeHttp(Method.PATCH, url, token, body, CONTENT_TYPE_JSON, false);
    }

    public ApiResponseHttp executeHttp(Method method, String url, String token, String reqBody, String contentType, boolean mandatory) {
        return this.executeHttp(this.buildRequest(method, url, token, reqBody, contentType), mandatory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponseHttp executeHttp(HttpUriRequestBase req, boolean mandatory) {
        try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)req);){
            ApiResponseHttp apiResponseHttp;
            ApiResponseHttp res;
            if (response == null) {
                res = new ApiResponseHttp("Response is empty, please check url", 503, null);
            } else {
                String body = null;
                if (null != response.getEntity()) {
                    body = EntityUtils.toString((HttpEntity)response.getEntity());
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                HashMap<String, String> headers = new HashMap<String, String>();
                Arrays.stream(response.getHeaders()).forEach(h -> headers.put(h.getName(), h.getValue()));
                res = new ApiResponseHttp(body, response.getCode(), headers);
            }
            if (404 == res.getCode() && !mandatory) {
                apiResponseHttp = res;
                return apiResponseHttp;
            }
            if (res.getCode() >= 300) {
                LOGGER.error("Error for request, url={}, method={}, body={}", new Object[]{req.getUri().toString(), req.getMethod(), EntityUtils.toString((HttpEntity)req.getEntity())});
                LOGGER.error("Response  code={}, body={}", (Object)res.getCode(), (Object)res.getBody());
                this.processErrors(res, mandatory);
                LOGGER.error("An HTTP Error occurred. The HTTP CODE Return is {}", (Object)res.getCode());
            }
            apiResponseHttp = res;
            return apiResponseHttp;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error in HTTP Request: " + e.getMessage(), e);
        }
    }

    private HttpUriRequestBase buildRequest(Method method, String url, String token, String body, String contentType) {
        HttpGet req;
        switch (method) {
            case GET: {
                req = new HttpGet(url);
                break;
            }
            case POST: {
                req = new HttpPost(url);
                break;
            }
            case PUT: {
                req = new HttpPut(url);
                break;
            }
            case DELETE: {
                req = new HttpDelete(url);
                break;
            }
            case PATCH: {
                req = new HttpPatch(url);
                break;
            }
            case HEAD: {
                req = new HttpHead(url);
                break;
            }
            case TRACE: {
                req = new HttpTrace(url);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid HTTP Method");
            }
        }
        req.addHeader(HEADER_CONTENT_TYPE, (Object)contentType);
        req.addHeader(HEADER_ACCEPT, (Object)CONTENT_TYPE_JSON);
        req.addHeader(HEADER_USER_AGENT, (Object)REQUEST_WITH);
        req.addHeader(HEADER_REQUESTED_WITH, (Object)REQUEST_WITH);
        req.addHeader(HEADER_AUTHORIZATION, (Object)("Bearer " + token));
        req.setConfig(requestConfig);
        if (null != body) {
            req.setEntity((HttpEntity)new StringEntity(body, ContentType.TEXT_PLAIN));
        }
        return req;
    }

    private void processErrors(ApiResponseHttp res, boolean mandatory) {
        switch (res.getCode()) {
            case 400: {
                throw new IllegalArgumentException("Error Code=" + res.getCode() + " (HTTP_BAD_REQUEST) Invalid Parameters: " + res.getBody());
            }
            case 401: {
                throw new AuthenticationException("Error Code=" + res.getCode() + ", (HTTP_UNAUTHORIZED) Invalid Credentials Check your token: " + res.getBody());
            }
            case 403: {
                throw new AuthenticationException("Error Code=" + res.getCode() + ", (HTTP_FORBIDDEN) Invalid permissions, check your token: " + res.getBody());
            }
            case 404: {
                if (!mandatory) break;
                throw new IllegalArgumentException("Error Code=" + res.getCode() + "(HTTP_NOT_FOUND) Object not found:  " + res.getBody());
            }
            case 409: {
                throw new AuthenticationException("Error Code=" + res.getCode() + ", (HTTP_CONFLICT) Object may already exist with same identifiers: " + res.getBody());
            }
            case 422: {
                throw new IllegalArgumentException("Error Code=" + res.getCode() + "(422) Invalid information provided to create DB: " + res.getBody());
            }
            default: {
                if (res.getCode() == 503) {
                    throw new IllegalStateException(res.getBody() + " (http:" + res.getCode() + ")");
                }
                throw new RuntimeException(res.getBody() + " (http:" + res.getCode() + ")");
            }
        }
    }
}

