/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.streaming;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.streaming.ClustersClient;
import com.dtsx.astra.sdk.streaming.ProvidersClient;
import com.dtsx.astra.sdk.streaming.RegionsClient;
import com.dtsx.astra.sdk.streaming.TenantClient;
import com.dtsx.astra.sdk.streaming.domain.CreateTenant;
import com.dtsx.astra.sdk.streaming.domain.Tenant;
import com.dtsx.astra.sdk.streaming.exception.TenantNotFoundException;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class AstraStreamingClient
extends AbstractApiClient {
    public AstraStreamingClient(String token) {
        this(token, AstraEnvironment.PROD);
    }

    public AstraStreamingClient(String token, AstraEnvironment env) {
        super(token, env);
    }

    public Stream<Tenant> findAll() {
        return JsonUtils.unmarshallType(this.GET(this.getApiDevopsEndpointTenants()).getBody(), new TypeReference<List<Tenant>>(){}).stream();
    }

    public Optional<Tenant> find(String tenantName) {
        return this.findAll().filter(t -> t.getTenantName().equalsIgnoreCase(tenantName)).findFirst();
    }

    public Tenant get(String tenantName) {
        return this.find(tenantName).orElseThrow(() -> new TenantNotFoundException(tenantName));
    }

    public void create(CreateTenant ct) {
        Assert.notNull(ct, "Create Tenant request");
        this.POST(this.getApiDevopsEndpointTenants(), JsonUtils.marshall(ct));
    }

    public void delete(String tenantName) {
        Tenant tenant = this.get(tenantName);
        this.DELETE(this.getEndpointCluster(tenant.getTenantName(), tenant.getClusterName()));
    }

    public boolean exist(String tenantName) {
        return this.HEAD(this.getEndpointTenant(tenantName)).getCode() == 200;
    }

    public TenantClient tenant(String tenantName) {
        return new TenantClient(this.token, this.environment, tenantName);
    }

    public ClustersClient clusters() {
        return new ClustersClient(this.token, this.environment);
    }

    public ProvidersClient providers() {
        return new ProvidersClient(this.token, this.environment);
    }

    public RegionsClient regions() {
        return new RegionsClient(this.token, this.environment);
    }

    public String getApiDevopsEndpointStreaming() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/streaming";
    }

    public String getApiDevopsEndpointTenants() {
        return this.getApiDevopsEndpointStreaming() + "/tenants";
    }

    public String getEndpointTenant(String tenantId) {
        return this.getApiDevopsEndpointTenants() + "/" + tenantId;
    }

    public String getEndpointCluster(String tenantName, String clusterId) {
        return this.getEndpointTenant(tenantName) + "/clusters/" + clusterId;
    }
}

