/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.db.domain.telemetry;

import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.HttpClientWrapper;
import com.dtsx.astra.sdk.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecializedTelemetryClient<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpecializedTelemetryClient.class);
    private final TypeReference<Map<String, T>> RESPONSE = new TypeReference<Map<String, T>>(){};
    private final String token;
    private final String key;
    private final String telemetryEndpoint;

    public SpecializedTelemetryClient(String token, String telemetryEndpoint, String key) {
        Assert.notNull(token, "databasesClient");
        Assert.hasLength(telemetryEndpoint, "telemetryEndpoint");
        this.token = token;
        this.key = key;
        this.telemetryEndpoint = telemetryEndpoint;
    }

    public ApiResponseHttp setup(T ktr) {
        HashMap<String, T> bodyMap = new HashMap<String, T>();
        bodyMap.put(this.key, ktr);
        return HttpClientWrapper.getInstance().POST(this.telemetryEndpoint, this.token, JsonUtils.mapAsJson(bodyMap));
    }

    public Optional<T> find() {
        ApiResponseHttp res = HttpClientWrapper.getInstance().GET(this.telemetryEndpoint, this.token);
        try {
            if (res.getCode() == 200) {
                return Optional.ofNullable(JsonUtils.unmarshallType(res.getBody(), this.RESPONSE).get(this.key));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot read telemetry configuration for " + this.key, (Throwable)e);
        }
        return Optional.empty();
    }
}

