/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.db;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.db.DbOpsClient;
import com.dtsx.astra.sdk.db.domain.CloudProviderType;
import com.dtsx.astra.sdk.db.domain.Database;
import com.dtsx.astra.sdk.db.domain.DatabaseRegionCreationRequest;
import com.dtsx.astra.sdk.db.domain.Datacenter;
import com.dtsx.astra.sdk.db.exception.RegionAlreadyExistException;
import com.dtsx.astra.sdk.db.exception.RegionNotFoundException;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponseHttp;
import com.dtsx.astra.sdk.utils.Assert;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class DbDatacentersClient
extends AbstractApiClient {
    private static final TypeReference<List<Datacenter>> DATACENTER_LIST = new TypeReference<List<Datacenter>>(){};
    private final Database db;

    public DbDatacentersClient(String token, String databaseId) {
        this(token, AstraEnvironment.PROD, databaseId);
    }

    public DbDatacentersClient(String token, AstraEnvironment env, String databaseId) {
        super(token, env);
        Assert.hasLength(databaseId, "databaseId");
        this.db = new DbOpsClient(token, env, databaseId).get();
    }

    public Stream<Datacenter> findAll() {
        ApiResponseHttp res = this.GET(this.getEndpointRegions());
        if (404 == res.getCode()) {
            return Stream.of(new Datacenter[0]);
        }
        return JsonUtils.unmarshallType(res.getBody(), DATACENTER_LIST).stream();
    }

    public Optional<Datacenter> findByRegionName(String regionName) {
        Assert.hasLength(regionName, "regionName");
        return this.findAll().filter(dc -> regionName.equals(dc.getRegion())).findFirst();
    }

    public boolean exist(String regionName) {
        return this.findByRegionName(regionName).isPresent();
    }

    public void create(String tier, CloudProviderType cloudProvider, String regionName) {
        Assert.hasLength(tier, "tier");
        Assert.notNull((Object)cloudProvider, "cloudProvider");
        Assert.hasLength(regionName, "regionName");
        if (this.findByRegionName(regionName).isPresent()) {
            throw new RegionAlreadyExistException(this.db.getId(), regionName);
        }
        DatabaseRegionCreationRequest req = new DatabaseRegionCreationRequest(tier, cloudProvider.getCode(), regionName);
        String body = JsonUtils.marshall(Collections.singletonList(req));
        ApiResponseHttp res = this.POST(this.getEndpointRegions(), body);
        if (res.getCode() != 201) {
            throw new IllegalStateException("Cannot Add Region: " + res.getBody());
        }
    }

    public void delete(String regionName) {
        Optional<Datacenter> optDc = this.findByRegionName(regionName);
        if (!optDc.isPresent()) {
            throw new RegionNotFoundException(this.db.getId(), regionName);
        }
        ApiResponseHttp res = this.POST(this.getEndpointRegions() + "/" + optDc.get().getId() + "/terminate");
        this.assertHttpCodeAccepted(res, "deleteRegion", this.db.getId());
    }

    private String getEndpointRegions() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/databases/" + this.db.getId() + "/datacenters";
    }
}

